/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.junit.Assert;
import org.junit.Test;

public class ReconcilerTest
extends AbstratGenericEditorTest {
    protected ExtensionBasedTextEditor secondEditor;
    protected IFile secondFile;
    protected IProject secondProject;

    @Test
    public void testReconciler() throws Exception {
        this.performTestOnEditor("foo", this.editor, "BAR");
    }

    @Test
    public void testEnabledWhenReconciler() throws Exception {
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "");
        this.performTestOnEditor("foo", this.editor, "BAR");
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "");
        this.performTestOnEditor("BAR", this.editor, "second");
    }

    @Test
    public void testMultipleEditors() throws Exception {
        this.secondProject = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.currentTimeMillis());
        this.secondProject.create(null);
        this.secondProject.open(null);
        this.secondFile = this.secondProject.getFile("foo.txt");
        this.secondFile.create((InputStream)new ByteArrayInputStream("bar 'bar'".getBytes()), true, null);
        this.secondEditor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.secondFile), "org.eclipse.ui.genericeditor.GenericEditor");
        this.performTestOnEditor("foo", this.editor, "BAR");
    }

    @Test
    public void testMultipleReconcilers() throws Exception {
        this.secondFile = this.project.getFile("bar.txt");
        this.secondFile.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
        this.secondEditor = (ExtensionBasedTextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(this.secondFile), "org.eclipse.ui.genericeditor.GenericEditor");
        this.performTestOnEditor("foo", this.secondEditor, "second");
    }

    private void performTestOnEditor(String startingText, ExtensionBasedTextEditor textEditor, final String expectedText) throws Exception {
        IDocumentProvider dp = textEditor.getDocumentProvider();
        final IDocument doc = dp.getDocument((Object)textEditor.getEditorInput());
        doc.set(startingText);
        new DisplayHelper(){

            protected boolean condition() {
                try {
                    return doc.get(0, doc.getLineLength(0)).contains(expectedText);
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault().getActiveShell().getDisplay(), 2000L);
        Assert.assertTrue((String)"file was not affected by reconciler", (boolean)doc.get().contains(expectedText));
    }

    @Override
    public void tearDown() throws Exception {
        if (this.secondEditor != null) {
            this.secondEditor.close(false);
            this.secondEditor = null;
            while (Display.getDefault().readAndDispatch()) {
            }
        }
        if (this.secondFile != null) {
            this.secondFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            this.secondFile = null;
        }
        super.tearDown();
        if (this.secondProject != null) {
            this.secondProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

