/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.genericeditor.tests.AbstratGenericEditorTest;
import org.eclipse.ui.genericeditor.tests.contributions.EnabledPropertyTester;
import org.junit.Assert;
import org.junit.Test;

public class StylingTest
extends AbstratGenericEditorTest {
    @Test
    public void testStyle() throws Exception {
        this.editor.selectAndReveal(4, 8);
        StyledText widget = (StyledText)this.editor.getAdapter(Control.class);
        StyleRange style = widget.getStyleRangeAtOffset(4);
        boolean isRed = style.foreground.getRGB().equals((Object)new RGB(255, 0, 0));
        Assert.assertTrue((String)"Token is not of expected color", (boolean)isRed);
    }

    @Test
    public void testEnabledWhenStyle() throws Exception {
        EnabledPropertyTester.setEnabled(true);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        this.editor.selectAndReveal(4, 8);
        StyledText widget = (StyledText)this.editor.getAdapter(Control.class);
        StyleRange style = widget.getStyleRangeAtOffset(4);
        boolean isBlue = style.foreground.getRGB().equals((Object)new RGB(0, 0, 255));
        Assert.assertTrue((String)"Token is not of expected color", (boolean)isBlue);
        this.cleanFileAndEditor();
        EnabledPropertyTester.setEnabled(false);
        this.createAndOpenFile("enabledWhen.txt", "bar 'bar'");
        this.editor.selectAndReveal(4, 8);
        widget = (StyledText)this.editor.getAdapter(Control.class);
        Assert.assertNull((Object)widget.getStyleRangeAtOffset(4));
    }
}

