/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.genericeditor.tests.contributions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public class FoldingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument document;
    private String oldDocument;
    private ProjectionViewer projectionViewer;
    private List<Annotation> oldAnnotations = new ArrayList<Annotation>();
    private List<Position> oldPositions = new ArrayList<Position>();

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setProjectionViewer(ProjectionViewer projectionViewer) {
        this.projectionViewer = projectionViewer;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.initialReconcile();
    }

    public void reconcile(IRegion partition) {
        this.initialReconcile();
    }

    public void initialReconcile() {
        if (this.document.get().equals(this.oldDocument)) {
            return;
        }
        this.oldDocument = this.document.get();
        List<Position> positions = this.getNewPositionsOfAnnotations();
        ArrayList<Position> positionsToRemove = new ArrayList<Position>();
        ArrayList<Annotation> annotationToRemove = new ArrayList<Annotation>();
        for (Position position : this.oldPositions) {
            if (!positions.contains(position)) {
                this.projectionViewer.getProjectionAnnotationModel().removeAnnotation(this.oldAnnotations.get(this.oldPositions.indexOf(position)));
                positionsToRemove.add(position);
                annotationToRemove.add(this.oldAnnotations.get(this.oldPositions.indexOf(position)));
                continue;
            }
            positions.remove(position);
        }
        this.oldPositions.removeAll(positionsToRemove);
        this.oldAnnotations.removeAll(annotationToRemove);
        for (Position position : positions) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            this.projectionViewer.getProjectionAnnotationModel().addAnnotation((Annotation)annotation, position);
            this.oldPositions.add(position);
            this.oldAnnotations.add((Annotation)annotation);
        }
    }

    private List<Position> getNewPositionsOfAnnotations() {
        ArrayList<Position> positions = new ArrayList<Position>();
        HashMap<String, Integer> startOfAnnotation = new HashMap<String, Integer>();
        SearchingFor searchingFor = SearchingFor.START_OF_TAG;
        int characters = this.document.getLength();
        int currentCharIndex = 0;
        int wordStartIndex = 0;
        int sectionStartIndex = 0;
        String word = "";
        try {
            while (currentCharIndex < characters) {
                char currentChar = this.document.getChar(currentCharIndex);
                switch (searchingFor) {
                    case START_OF_TAG: {
                        char nextChar;
                        if (currentChar != '<' || (nextChar = this.document.getChar(currentCharIndex + 1)) == '?') break;
                        sectionStartIndex = currentCharIndex;
                        searchingFor = SearchingFor.START_OF_WORD;
                        break;
                    }
                    case START_OF_WORD: {
                        if (!Character.isLetter(currentChar)) break;
                        wordStartIndex = currentCharIndex;
                        searchingFor = SearchingFor.END_OF_WORD;
                        break;
                    }
                    case END_OF_WORD: {
                        if (Character.isLetter(currentChar)) break;
                        word = this.document.get(wordStartIndex, currentCharIndex - wordStartIndex);
                        if (startOfAnnotation.containsKey(word)) {
                            searchingFor = SearchingFor.END_OF_LINE;
                            break;
                        }
                        startOfAnnotation.put(word, sectionStartIndex);
                        searchingFor = SearchingFor.START_OF_TAG;
                        break;
                    }
                    case END_OF_LINE: {
                        if (currentChar != '\n') break;
                        int start = (Integer)startOfAnnotation.get(word);
                        if (this.document.getLineOfOffset(start) != this.document.getLineOfOffset(currentCharIndex)) {
                            positions.add(new Position(start, currentCharIndex + 1 - start));
                        }
                        startOfAnnotation.remove(word);
                        searchingFor = SearchingFor.START_OF_TAG;
                    }
                }
                ++currentCharIndex;
            }
        }
        catch (BadLocationException badLocationException) {}
        return positions;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    private static enum SearchingFor {
        START_OF_TAG,
        START_OF_WORD,
        END_OF_WORD,
        END_OF_LINE;

    }
}

