/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.internal.forms.widgets.ColumnLayoutUtils;
import org.eclipse.ui.tests.forms.layout.ControlFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestColumnWrapLayout {
    private final Point p20 = new Point(100, 20);
    private final Point p30 = new Point(100, 30);
    private final Point p50 = new Point(100, 50);
    private final Point p100 = new Point(100, 100);
    private final Point p200 = new Point(100, 200);
    private Display display;
    private Shell shell;
    private Composite inner;
    private ColumnLayout layout;

    @Before
    public void setUp() {
        this.display = PlatformUI.getWorkbench().getDisplay();
        this.shell = new Shell(this.display);
        this.inner = new Composite((Composite)this.shell, 0);
        this.inner.setSize(100, 300);
        this.layout = new ColumnLayout();
        this.layout.leftMargin = 0;
        this.layout.rightMargin = 0;
        this.layout.topMargin = 0;
        this.layout.bottomMargin = 0;
        this.layout.horizontalSpacing = 0;
        this.layout.verticalSpacing = 0;
        this.inner.setLayout((Layout)this.layout);
    }

    @After
    public void tearDown() {
        this.shell.dispose();
    }

    @Test
    public void testEqualSizeColumns() {
        Point[] sizes = new Point[]{this.p20, this.p30, this.p30, this.p20, this.p20, this.p30};
        Assert.assertEquals((long)50L, (long)ColumnLayoutUtils.computeColumnHeight((int)3, (Point[])sizes, (int)237, (int)0));
    }

    @Test
    public void testEqualSizeColumnsWithMargins() {
        Point[] sizes = new Point[]{this.p20, this.p30, this.p30, this.p20, this.p20, this.p30};
        Assert.assertEquals((long)60L, (long)ColumnLayoutUtils.computeColumnHeight((int)3, (Point[])sizes, (int)200, (int)10));
    }

    @Test
    public void testVariedSizeColumns() {
        Point[] sizes = new Point[]{this.p200, this.p200, this.p30};
        Assert.assertEquals((long)230L, (long)ColumnLayoutUtils.computeColumnHeight((int)2, (Point[])sizes, (int)100, (int)0));
    }

    @Test
    public void testLastEntryLargest() {
        Point[] sizes = new Point[]{this.p50, this.p30, this.p30, this.p30, this.p50, this.p50, this.p100};
        Assert.assertEquals((long)100L, (long)ColumnLayoutUtils.computeColumnHeight((int)4, (Point[])sizes, (int)100, (int)0));
    }

    @Test
    public void testLargeMargins() {
        Point[] sizes = new Point[]{this.p20, this.p20, this.p20, this.p20, this.p20, this.p50, this.p50};
        Assert.assertEquals((long)260L, (long)ColumnLayoutUtils.computeColumnHeight((int)3, (Point[])sizes, (int)100, (int)100));
    }

    @Test
    public void testColumnLayoutInShell() {
        this.layout.verticalSpacing = 5;
        this.layout.horizontalSpacing = 5;
        this.layout.minNumColumns = 2;
        this.layout.maxNumColumns = 2;
        this.layout.topMargin = 2;
        this.layout.bottomMargin = 3;
        this.layout.leftMargin = 5;
        this.layout.rightMargin = 5;
        ControlFactory.create(this.inner, 20, 20, 30);
        ControlFactory.create(this.inner, 20, 20, 40);
        ControlFactory.create(this.inner, 20, 20, 20);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)70L, (long)size.y);
        this.inner.setSize(size);
        this.inner.layout(true);
        Assert.assertEquals((Object)new Rectangle(5, 2, 20, 30), (Object)this.inner.getChildren()[0].getBounds());
        Assert.assertEquals((Object)new Rectangle(30, 2, 20, 40), (Object)this.inner.getChildren()[1].getBounds());
    }

    @Test
    public void testHorizontalSpacingHasNoEffectWhenOnlyOneColumn() {
        this.layout.horizontalSpacing = 1000;
        Composite control = ControlFactory.create(this.inner, 20, 20, 30);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)20L, (long)size.x);
        this.inner.pack(true);
        Assert.assertEquals((Object)new Rectangle(0, 0, 20, 30), (Object)control.getBounds());
    }

    @Test
    public void testHorizontalSpacing() {
        this.layout.horizontalSpacing = 1000;
        ControlFactory.create(this.inner, 20, 20, 30);
        Composite secondControl = ControlFactory.create(this.inner, 20, 20, 30);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)1040L, (long)size.x);
        this.inner.pack(true);
        Assert.assertEquals((Object)new Rectangle(1020, 0, 20, 30), (Object)secondControl.getBounds());
    }

    @Test
    public void testHorizontalMargins() {
        this.layout.leftMargin = 100;
        this.layout.rightMargin = 10;
        Composite leftControl = ControlFactory.create(this.inner, 20, 20, 30);
        Composite rightControl = ControlFactory.create(this.inner, 20, 20, 40);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)150L, (long)size.x);
        this.inner.pack(true);
        Assert.assertEquals((Object)new Rectangle(100, 0, 20, 30), (Object)leftControl.getBounds());
        Assert.assertEquals((Object)new Rectangle(120, 0, 20, 40), (Object)rightControl.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 0, 150, 40), (Object)this.inner.getBounds());
    }

    @Test
    public void testVerticalSpacingHasNoEffectWhenOnlyOneColumn() {
        this.layout.verticalSpacing = 1000;
        Composite control = ControlFactory.create(this.inner, 20, 20, 30);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)20L, (long)size.x);
        this.inner.pack(true);
        Assert.assertEquals((Object)new Rectangle(0, 0, 20, 30), (Object)control.getBounds());
    }

    @Test
    public void testVerticalSpacing() {
        this.layout.verticalSpacing = 1000;
        this.layout.maxNumColumns = 1;
        ControlFactory.create(this.inner, 20, 20, 30);
        Composite secondControl = ControlFactory.create(this.inner, 20, 20, 30);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)1060L, (long)size.y);
        this.inner.pack(true);
        Assert.assertEquals((Object)new Rectangle(0, 1030, 20, 30), (Object)secondControl.getBounds());
    }

    @Test
    public void testVerticalMargins() {
        this.layout.topMargin = 100;
        this.layout.bottomMargin = 10;
        this.layout.maxNumColumns = 1;
        Composite control1 = ControlFactory.create(this.inner, 20, 20, 30);
        Composite control2 = ControlFactory.create(this.inner, 20, 20, 40);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)180L, (long)size.y);
        this.inner.pack();
        Assert.assertEquals((Object)new Rectangle(0, 100, 20, 30), (Object)control1.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 130, 20, 40), (Object)control2.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 0, 20, 180), (Object)this.inner.getBounds());
    }

    @Test
    public void testSelectsCorrectNumberOfColumns() {
        this.layout.horizontalSpacing = 10;
        this.layout.leftMargin = 10;
        this.layout.rightMargin = 10;
        ControlFactory.create(this.inner, 21, 30, 50);
        ControlFactory.create(this.inner, 22, 40, 50);
        ControlFactory.create(this.inner, 23, 50, 50);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)190L, (long)size.x);
        Assert.assertEquals((long)50L, (long)size.y);
        size = this.inner.computeSize(109, -1);
        Assert.assertEquals((long)109L, (long)size.x);
        Assert.assertEquals((long)108L, (long)size.y);
        this.inner.pack(true);
        this.assertAllChildrenHaveWidth(50);
        Control[] controlArray = this.inner.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control next = controlArray[n2];
            Assert.assertEquals((long)0L, (long)next.getBounds().y);
            ++n2;
        }
        size = this.inner.computeSize(108, -1);
        Assert.assertEquals((long)108L, (long)size.x);
        Assert.assertEquals((long)89L, (long)size.y);
        int minWidth = this.layout.computeMinimumWidth(this.inner, false);
        Assert.assertEquals((long)43L, (long)minWidth);
    }

    @Test
    public void testFillAlignment() {
        this.layout.maxNumColumns = 1;
        Composite control1 = ControlFactory.create(this.inner, 100, 800, 200);
        ColumnLayoutData data1 = new ColumnLayoutData();
        data1.widthHint = 400;
        control1.setLayoutData((Object)data1);
        Composite control2 = ControlFactory.create(this.inner, 50, 100, 1200);
        ColumnLayoutData data2 = new ColumnLayoutData();
        data2.widthHint = 200;
        control2.setLayoutData((Object)data2);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)400L, (long)size.x);
        Assert.assertEquals((long)700L, (long)size.y);
        this.inner.pack();
        Assert.assertEquals((Object)new Rectangle(0, 0, 400, 400), (Object)control1.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 400, 400, 300), (Object)control2.getBounds());
    }

    @Test
    public void testLeftAlignment() {
        this.layout.maxNumColumns = 1;
        Composite control1 = ControlFactory.create(this.inner, 200, 200, 200);
        Composite control2 = ControlFactory.create(this.inner, 10, 100, 100);
        ColumnLayoutData data2 = new ColumnLayoutData();
        data2.horizontalAlignment = 1;
        data2.widthHint = 50;
        control2.setLayoutData((Object)data2);
        Composite control3 = ControlFactory.create(this.inner, 10, 50, 100);
        ColumnLayoutData data3 = new ColumnLayoutData();
        data3.widthHint = 10;
        data3.horizontalAlignment = 1;
        control3.setLayoutData((Object)data3);
        Point size = this.inner.computeSize(-1, -1);
        Assert.assertEquals((long)200L, (long)size.x);
        Assert.assertEquals((long)900L, (long)size.y);
        this.inner.pack(true);
        Assert.assertEquals((Object)new Rectangle(0, 0, 200, 200), (Object)control1.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 200, 50, 200), (Object)control2.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 400, 10, 500), (Object)control3.getBounds());
        size = this.inner.computeSize(25, -1);
        Assert.assertEquals((long)25L, (long)size.x);
        Assert.assertEquals((long)2500L, (long)size.y);
    }

    @Test
    public void testControlsFlushedCorrectly() {
        Composite composite = ControlFactory.create(this.inner, 200, 200, 200);
        ControlFactory.TestLayout layout = (ControlFactory.TestLayout)composite.getLayout();
        this.inner.computeSize(-1, -1, false);
        layout.wasChanged = false;
        this.inner.computeSize(-1, -1, false);
        Assert.assertEquals((Object)false, (Object)layout.wasChanged);
        this.inner.computeSize(-1, -1, true);
        Assert.assertEquals((Object)true, (Object)layout.wasChanged);
        layout.wasChanged = false;
        this.inner.layout(false);
        Assert.assertEquals((Object)false, (Object)layout.wasChanged);
        this.inner.layout(true);
        Assert.assertEquals((Object)true, (Object)layout.wasChanged);
    }

    private void assertAllChildrenHaveWidth(int desiredWidth) {
        Control[] children = this.inner.getChildren();
        int idx = 0;
        while (idx < children.length) {
            Control next = children[idx];
            Rectangle bounds = next.getBounds();
            Assert.assertEquals((String)("Child " + idx + " should have the correct width"), (long)desiredWidth, (long)bounds.width);
            ++idx;
        }
    }
}

