/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.tests.forms.layout.ControlFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTableWrapLayout {
    private Display display;
    private Shell shell;
    private Composite inner;
    private TableWrapLayout layout;

    private int rightEdge(Control lab) {
        Rectangle r = lab.getBounds();
        return r.x + r.width;
    }

    @Before
    public void setUp() {
        this.display = PlatformUI.getWorkbench().getDisplay();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FillLayout());
        this.inner = new Composite((Composite)this.shell, 0);
        this.inner.setSize(100, 300);
        this.layout = new TableWrapLayout();
        this.layout.leftMargin = 0;
        this.layout.rightMargin = 0;
        this.layout.topMargin = 0;
        this.layout.bottomMargin = 0;
        this.layout.horizontalSpacing = 0;
        this.layout.verticalSpacing = 0;
        this.inner.setLayout((Layout)this.layout);
    }

    @After
    public void tearDown() {
        this.shell.dispose();
    }

    @Test
    public void testSimpleTwoCellLayout() {
        Composite l1 = ControlFactory.create(this.inner, 10, 100, 80);
        Composite l2 = ControlFactory.create(this.inner, 80, 800, 15);
        Point preferredSize = this.inner.computeSize(-1, -1);
        int minimumWidth = this.layout.computeMinimumWidth(this.inner, false);
        Point wrappedSize = this.inner.computeSize(400, -1);
        this.inner.pack();
        Assert.assertEquals((Object)new Rectangle(0, 0, 800, 10), (Object)l1.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 10, 800, 15), (Object)l2.getBounds());
        Assert.assertEquals((Object)new Point(800, 25), (Object)preferredSize);
        Assert.assertEquals((long)80L, (long)minimumWidth);
        Assert.assertEquals((Object)new Point(400, 50), (Object)wrappedSize);
    }

    @Test
    public void testWrappingPoint() {
        Composite l1 = ControlFactory.create(this.inner, 30, 100, 15);
        Point preferredSize = this.inner.computeSize(-1, -1, false);
        int preferredHeightWheneThereIsExtraHorizontalSpace = this.inner.computeSize((int)200, (int)-1).y;
        int preferredHeightWhenControlFillsSpace = this.inner.computeSize((int)100, (int)-1).y;
        int preferredHeightWhenControlCompressed = this.inner.computeSize((int)50, (int)-1).y;
        Assert.assertEquals((long)15L, (long)preferredHeightWheneThereIsExtraHorizontalSpace);
        Assert.assertEquals((long)15L, (long)preferredHeightWhenControlFillsSpace);
        Assert.assertEquals((long)30L, (long)preferredHeightWhenControlCompressed);
        Assert.assertEquals((Object)new Point(100, 15), (Object)preferredSize);
        this.inner.setSize(100, 15);
        this.inner.layout();
        Assert.assertEquals((long)15L, (long)l1.getSize().y);
        this.inner.setSize(100, 300);
        this.inner.layout();
        Assert.assertEquals((long)15L, (long)l1.getSize().y);
        this.inner.setSize(50, 300);
        this.inner.layout();
        Assert.assertEquals((long)30L, (long)l1.getSize().y);
        Assert.assertEquals((long)30L, (long)this.layout.computeMinimumWidth(this.inner, false));
        Assert.assertEquals((long)100L, (long)this.layout.computeMaximumWidth(this.inner, false));
    }

    @Test
    public void testTableWrapLayoutWrappingLabels() {
        Composite l1 = ControlFactory.create(this.inner, 30, 100, 30);
        Composite l2 = ControlFactory.create(this.inner, 50, 800, 15);
        this.inner.setSize(300, 1000);
        this.inner.layout(false);
        Assert.assertEquals((String)"l1 had the wrong bounds", (Object)new Rectangle(0, 0, 300, 10), (Object)l1.getBounds());
        Assert.assertEquals((String)"l2 had the wrong bounds", (Object)new Rectangle(0, 10, 300, 40), (Object)l2.getBounds());
    }

    @Test
    public void testTableWrapLayoutTwoColumnsWrappingLabels() {
        this.layout.numColumns = 2;
        Composite l1 = ControlFactory.create(this.inner, 31, 100, 15);
        Composite l2 = ControlFactory.create(this.inner, 32, 200, 15);
        Composite l3 = ControlFactory.create(this.inner, 33, 400, 15);
        Composite l4 = ControlFactory.create(this.inner, 34, 800, 15);
        this.inner.setSize(300, 1000);
        this.inner.layout(false);
        Assert.assertEquals((long)300L, (long)(l3.getBounds().width + l4.getBounds().width));
        Assert.assertTrue((this.rightEdge((Control)l1) <= l2.getBounds().x ? 1 : 0) != 0);
        Assert.assertEquals((long)this.rightEdge((Control)l3), (long)l4.getBounds().x);
        Assert.assertTrue((this.bottomEdge((Control)l1) <= l3.getBounds().y ? 1 : 0) != 0);
        Assert.assertTrue((this.bottomEdge((Control)l1) <= l4.getBounds().y ? 1 : 0) != 0);
        Point preferredSize = this.inner.computeSize(-1, -1, false);
        Assert.assertEquals((Object)new Point(1200, 18), (Object)preferredSize);
        int minWidth = this.layout.computeMinimumWidth(this.inner, false);
        Assert.assertEquals((long)67L, (long)minWidth);
    }

    public void suppressed_testCompressedBelowMinimumSize() {
        this.layout.numColumns = 2;
        Composite l1 = ControlFactory.create(this.inner, 50, 200, 50);
        l1.setLayoutData((Object)new TableWrapData(256, 128));
        Composite l2 = ControlFactory.create(this.inner, 200, 200, 50);
        l2.setLayoutData((Object)new TableWrapData(128, 128));
        Composite l3 = ControlFactory.create(this.inner, 400, 400, 50);
        TableWrapData data = new TableWrapData(128, 128);
        data.colspan = 2;
        l3.setLayoutData((Object)data);
        this.inner.setSize(300, 1000);
        this.inner.layout(false);
        Assert.assertEquals((Object)new Rectangle(0, 0, 100, 50), (Object)l1.getBounds());
        Assert.assertEquals((Object)new Rectangle(100, 0, 200, 50), (Object)l1.getBounds());
        Assert.assertEquals((Object)new Rectangle(0, 50, 300, 50), (Object)l1.getBounds());
    }

    private boolean runAlignmentTest(Control control, int alignment) {
        TableWrapData dataLeft = new TableWrapData();
        dataLeft.align = alignment;
        dataLeft.grabHorizontal = true;
        control.setLayoutData((Object)dataLeft);
        this.inner.setSize(1000, 1000);
        this.inner.layout(false);
        return control.getSize().x == 1000;
    }

    @Test
    public void testLeftAlignmentIsIgnoredForWrappingControls() {
        Label label = new Label(this.inner, 64);
        label.setText("test");
        Assert.assertEquals((Object)true, (Object)this.runAlignmentTest((Control)label, 2));
    }

    @Test
    public void testLeftAlignmentIsRespectedForNonWrappingControls() {
        Label label = new Label(this.inner, 0);
        label.setText("test");
        Assert.assertEquals((Object)false, (Object)this.runAlignmentTest((Control)label, 2));
    }

    @Test
    public void testLeftAlignmentIsIgnoredForLayoutsImplementingLayoutExtension() {
        Composite label = ControlFactory.create(this.inner, 10, 200, 100);
        Assert.assertEquals((Object)true, (Object)this.runAlignmentTest((Control)label, 2));
    }

    @Test
    public void testRightAlignmentIsIgnoredForWrappingControls() {
        Label label = new Label(this.inner, 64);
        label.setText("test");
        Assert.assertEquals((Object)true, (Object)this.runAlignmentTest((Control)label, 8));
    }

    @Test
    public void testRightAlignmentIsRespectedForNonWrappingControls() {
        Label label = new Label(this.inner, 0);
        label.setText("test");
        Assert.assertEquals((Object)false, (Object)this.runAlignmentTest((Control)label, 8));
    }

    @Test
    public void testRightAlignmentIsIgnoredForLayoutsImplementingLayoutExtension() {
        Composite label = ControlFactory.create(this.inner, 10, 200, 100);
        Assert.assertEquals((Object)true, (Object)this.runAlignmentTest((Control)label, 8));
    }

    @Test
    public void testCenterAlignmentIsIgnoredForWrappingControls() {
        Label label = new Label(this.inner, 64);
        label.setText("test");
        Assert.assertEquals((Object)true, (Object)this.runAlignmentTest((Control)label, 4));
    }

    @Test
    public void testCenterAlignmentIsRespectedForNonWrappingControls() {
        Label label = new Label(this.inner, 0);
        label.setText("test");
        Assert.assertEquals((Object)false, (Object)this.runAlignmentTest((Control)label, 4));
    }

    @Test
    public void testCenterAlignmentIsIgnoredForLayoutsImplementingLayoutExtension() {
        Composite label = ControlFactory.create(this.inner, 10, 200, 100);
        Assert.assertEquals((Object)true, (Object)this.runAlignmentTest((Control)label, 4));
    }

    @Test
    public void testTableWrapLayoutAlignment() {
        this.layout.leftMargin = 1;
        this.layout.rightMargin = 2;
        this.layout.topMargin = 3;
        this.layout.bottomMargin = 4;
        Composite lab0 = ControlFactory.create(this.inner, 50, 800, 15);
        Composite labLeft = ControlFactory.create(this.inner, 50, 100, 15);
        TableWrapData dataLeft = new TableWrapData();
        dataLeft.align = 2;
        labLeft.setLayoutData((Object)dataLeft);
        Composite labRight = ControlFactory.create(this.inner, 100, 15);
        TableWrapData dataRight = new TableWrapData();
        dataRight.align = 8;
        labRight.setLayoutData((Object)dataRight);
        Composite labCenter = ControlFactory.create(this.inner, 50, 100, 15);
        TableWrapData dataCenter = new TableWrapData();
        dataCenter.align = 4;
        labCenter.setLayoutData((Object)dataCenter);
        Composite labFill = ControlFactory.create(this.inner, 50, 100, 15);
        TableWrapData dataFill = new TableWrapData();
        dataFill.align = 128;
        labFill.setLayoutData((Object)dataFill);
        this.inner.setSize(303, 1000);
        this.inner.layout(false);
        Assert.assertEquals((Object)new Rectangle(1, 3, 300, 40), (Object)lab0.getBounds());
        Assert.assertEquals((Object)new Rectangle(1, this.bottomEdge((Control)lab0), 300, 5), (Object)labLeft.getBounds());
        Assert.assertEquals((Object)new Rectangle(this.rightEdge((Control)lab0) - 100, this.bottomEdge((Control)labLeft), 100, 15), (Object)labRight.getBounds());
        int centerPoint = (this.leftEdge((Control)labCenter) + this.rightEdge((Control)labCenter)) / 2;
        Assert.assertEquals((long)150L, (long)(centerPoint - 1));
        Assert.assertEquals((Object)new Rectangle(1, this.bottomEdge((Control)labCenter), 300, 5), (Object)labFill.getBounds());
    }

    private int leftEdge(Control control) {
        Rectangle bounds = control.getBounds();
        return bounds.x;
    }

    private int bottomEdge(Control control) {
        Rectangle bounds = control.getBounds();
        return bounds.y + bounds.height;
    }
}

