/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.performance;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.junit.Test;

public class FormsPerformanceTest
extends PerformanceTestCase {
    @Test
    public void test_createForm() {
        Composite c;
        int i;
        Shell shell;
        this.tagAsSummary("Create Form", Dimension.ELAPSED_PROCESS);
        Performance.getDefault();
        Display display = PlatformUI.getWorkbench().getDisplay();
        FormToolkit toolkit = new FormToolkit(display);
        int samples = 0;
        while (samples < 2) {
            shell = new Shell(display);
            shell.setSize(400, 300);
            shell.setLayout((Layout)new FillLayout());
            shell.open();
            i = 0;
            while (i < 5) {
                c = new Composite((Composite)shell, 768);
                c.setLayout((Layout)new FillLayout());
                this.createPartControl(c, toolkit);
                shell.layout(true);
                while (display.readAndDispatch()) {
                }
                c.dispose();
                ++i;
            }
            shell.dispose();
            while (display.readAndDispatch()) {
            }
            ++samples;
        }
        samples = 0;
        while (samples < 50) {
            shell = new Shell(display);
            shell.setSize(400, 300);
            shell.setLayout((Layout)new FillLayout());
            shell.open();
            this.startMeasuring();
            i = 0;
            while (i < 3) {
                c = new Composite((Composite)shell, 768);
                c.setLayout((Layout)new FillLayout());
                this.createPartControl(c, toolkit);
                shell.layout(true);
                while (display.readAndDispatch()) {
                }
                c.dispose();
                ++i;
            }
            this.stopMeasuring();
            shell.dispose();
            while (display.readAndDispatch()) {
            }
            ++samples;
        }
        toolkit.dispose();
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void createPartControl(Composite parent, FormToolkit toolkit) {
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.setText("Hello, Eclipse Forms");
        TableWrapLayout layout = new TableWrapLayout();
        form.getBody().setLayout((Layout)layout);
        Hyperlink link = toolkit.createHyperlink(form.getBody(), "Click here.", 64);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                System.out.println("Link activated!");
            }
        });
        link.setText("This is an example of a form that is much longer and will need to wrap.");
        layout.numColumns = 2;
        TableWrapData td = new TableWrapData();
        td.colspan = 2;
        link.setLayoutData((Object)td);
        toolkit.createLabel(form.getBody(), "Text field label:");
        Text text = toolkit.createText(form.getBody(), "");
        td = new TableWrapData(256);
        text.setLayoutData((Object)td);
        Button button = toolkit.createButton(form.getBody(), "An example of a checkbox in a form", 32);
        td = new TableWrapData();
        td.colspan = 2;
        button.setLayoutData((Object)td);
        ImageHyperlink ih = toolkit.createImageHyperlink(form.getBody(), 0);
        ih.setText("Image link with no image");
        ih = toolkit.createImageHyperlink(form.getBody(), 0);
        ih.setText("Link with image and text");
        ExpandableComposite ec = toolkit.createExpandableComposite(form.getBody(), 20);
        ImageHyperlink eci = toolkit.createImageHyperlink((Composite)ec, 0);
        ec.setTextClient((Control)eci);
        ec.setText("Expandable Composite title");
        String ctext = "We will now create a somewhat long text so that we can use it as content for the expandable composite. Expandable composite is used to hide or show the text using the toggle control";
        Label client = toolkit.createLabel((Composite)ec, ctext, 64);
        ec.setClient((Control)client);
        td = new TableWrapData();
        td.colspan = 2;
        ec.setLayoutData((Object)td);
        ec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        Section section = toolkit.createSection(form.getBody(), 194);
        td = new TableWrapData(128);
        td.colspan = 2;
        section.setLayoutData((Object)td);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        section.setText("Section title");
        toolkit.createCompositeSeparator((Composite)section);
        section.setDescription("This is the description that goes below the title");
        Composite sectionClient = toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout());
        button = toolkit.createButton(sectionClient, "Radio 1", 16);
        button = toolkit.createButton(sectionClient, "Radio 2", 16);
        section.setClient((Control)sectionClient);
        StringBuilder buf = new StringBuilder();
        buf.append("<form>");
        buf.append("<p>");
        buf.append("Here is some plain text for the text to render; ");
        buf.append("this text is at <a href=\"http://www.eclipse.org\" nowrap=\"true\">http://www.eclipse.org</a> web site.");
        buf.append("</p>");
        buf.append("<p>");
        buf.append("<span color=\"header\" font=\"header\">This text is in header font.</span>");
        buf.append("</p>");
        buf.append("<p>This line will contain some <b>bold</b> and some <span font=\"code\">source</span> text. ");
        buf.append("We can also add <img href=\"image\"/> an image. ");
        buf.append("</p>");
        buf.append("<li>A default (bulleted) list item.</li>");
        buf.append("<li>Another bullet list item.</li>");
        buf.append("<li style=\"text\" value=\"1.\">A list item with text.</li>");
        buf.append("<li style=\"text\" value=\"2.\">Another list item with text</li>");
        buf.append("<li style=\"image\" value=\"image\">List item with an image bullet</li>");
        buf.append("<li style=\"text\" bindent=\"20\" indent=\"40\" value=\"3.\">A list item with text.</li>");
        buf.append("<li style=\"text\" bindent=\"20\" indent=\"40\" value=\"4.\">A list item with text.</li>");
        buf.append("<p>     leading blanks;      more white \n\n new lines   <br/><br/><br/> \n more <b>   bb   </b>  white  . </p>");
        buf.append("</form>");
        FormText rtext = toolkit.createFormText(form.getBody(), false);
        td = new TableWrapData(128);
        td.colspan = 2;
        rtext.setLayoutData((Object)td);
        rtext.setFont("header", JFaceResources.getHeaderFont());
        rtext.setFont("code", JFaceResources.getTextFont());
        rtext.setText(buf.toString(), true, false);
        rtext.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                System.out.println("Link active: " + e.getHref());
            }
        });
        toolkit.paintBordersFor(form.getBody());
    }
}

