/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.forms.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.tests.forms.layout.ControlFactory;
import org.eclipse.ui.tests.forms.widgets.ScrollTestData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScrolledFormTest {
    private Shell shell;
    private Display display;

    @Before
    public void setUp() throws Exception {
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
    }

    @After
    public void tearDown() throws Exception {
        this.shell.dispose();
    }

    public void disabled_testWrapping() {
        this.runTest(new ScrollTestData().setMax(200, 20).expand(false, true).expectScroll(true, false), 200, 83);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(false, true).setMinWidth(25).expectScroll(false, true), 83, 963);
        this.runTest(new ScrollTestData().setMax(200, 400).setMinWidth(25).expectScroll(false, true), 83, 963);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(true, true).setMinWidth(25).expectScroll(false, true), 83, 963);
        this.runTest(new ScrollTestData().setMax(50, 400).expand(true, true).expectScroll(false, true), 83, 240);
        this.runTest(new ScrollTestData().setMax(50, 400).expand(true, false).expectScroll(false, true), 83, 240);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(true, false).setMinWidth(25).expectScroll(false, true), 83, 963);
        this.runTest(new ScrollTestData().setMax(200, 20).expand(true, true).expectScroll(true, false), 200, 83);
    }

    @Test
    public void testVerticalExpand() {
        this.runTest(new ScrollTestData().setMax(50, 20).expand(false, true), 50, 100);
        this.runTest(new ScrollTestData().setMax(50, 400).expand(false, true).expectScroll(false, true), 50, 400);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(false, true).expectScroll(true, true), 200, 400);
        this.runTest(new ScrollTestData().setMax(50, 20).expand(false, true).setMinWidth(25), 50, 100);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(false, true).setMinWidth(150).expectScroll(true, true), 150, 533);
    }

    @Test
    public void testNoExpand() {
        this.runTest(new ScrollTestData().setMax(50, 20), 50, 20);
        this.runTest(new ScrollTestData().setMax(50, 400).expectScroll(false, true), 50, 400);
        this.runTest(new ScrollTestData().setMax(200, 400).expectScroll(true, true), 200, 400);
        this.runTest(new ScrollTestData().setMax(200, 20).expectScroll(true, false), 200, 20);
        this.runTest(new ScrollTestData().setMax(50, 20).setMinWidth(25), 50, 20);
        this.runTest(new ScrollTestData().setMax(200, 400).setMinWidth(150).expectScroll(true, true), 150, 533);
    }

    @Test
    public void testHorizontalExpand() {
        this.runTest(new ScrollTestData().setMax(50, 20).expand(true, false), 100, 11);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(true, false).expectScroll(true, true), 200, 400);
        this.runTest(new ScrollTestData().setMax(200, 20).expand(true, false).expectScroll(true, false), 200, 20);
        this.runTest(new ScrollTestData().setMax(50, 20).expand(true, false).setMinWidth(25), 100, 11);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(true, false).setMinWidth(150).expectScroll(true, true), 150, 533);
    }

    @Test
    public void testExpandBoth() {
        this.runTest(new ScrollTestData().setMax(50, 20).expand(true, true), 100, 100);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(true, true).expectScroll(true, true), 200, 400);
        this.runTest(new ScrollTestData().setMax(50, 20).expand(true, true).setMinWidth(25), 100, 100);
        this.runTest(new ScrollTestData().setMax(200, 400).expand(true, true).setMinWidth(150).expectScroll(true, true), 150, 533);
    }

    public static Point computeLayout(Shell shell, ScrollTestData testData) {
        ScrolledForm form = new ScrolledForm((Composite)shell);
        Composite parent = form.getBody();
        form.setExpandHorizontal(testData.expandHorizontal());
        form.setExpandVertical(testData.expandVertical());
        ControlFactory.TestLayout layout = testData.useLayoutExtension() ? ControlFactory.createLayout(testData.getMinWidth(), testData.getMaxWidth(), testData.getMaxHeight()) : ControlFactory.createLayout(testData.getMaxWidth(), testData.getMaxHeight());
        parent.setLayout((Layout)layout);
        form.setMinSize(testData.getFormMinX(), testData.getFormMinY());
        int hAdjust = form.getVerticalBar().getSize().x - 17;
        int vAdjust = form.getHorizontalBar().getSize().y - 17;
        form.setSize(100 + (testData.expectsVScroll() ? hAdjust : 0), 100 + (testData.expectsHScroll() ? vAdjust : 0));
        form.layout(true);
        while (!shell.isDisposed() && shell.getDisplay().readAndDispatch()) {
        }
        Assert.assertEquals((String)("Horizontal scrollbar visibility was wrong for " + testData), (Object)testData.expectsHScroll(), (Object)form.getHorizontalBar().getVisible());
        Assert.assertEquals((String)("Vertical scrollbar visibility was wrong for " + testData), (Object)testData.expectsVScroll(), (Object)form.getVerticalBar().getVisible());
        Point result = parent.getSize();
        form.dispose();
        return result;
    }

    private void runTest(ScrollTestData testData, int expectedWidth, int expectedHeight) {
        boolean widthOkay;
        Point result = ScrolledFormTest.computeLayout(this.shell, testData);
        boolean heightOkay = Math.abs(expectedHeight - result.y) <= 1;
        boolean bl = widthOkay = expectedWidth == result.x;
        if (!heightOkay || !widthOkay) {
            Assert.assertEquals((String)("Child control had unexpected size for test case " + testData.toString()), (Object)new Point(expectedWidth, expectedHeight), (Object)result);
        }
    }
}

