/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.tests;

import java.lang.reflect.UndeclaredThrowableException;
import org.eclipse.ui.tests.harness.util.Mocks;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MocksTest {
    private IPrimitive primitiveMock;
    private static boolean uninitializedBoolean;
    private static byte unitializedByte;
    private static char unitializedChar;
    private static short unitializedShort;
    private static int unitializedInt;
    private static long unitializedLong;
    private static float unitializedFloat;
    private static double unitializedDouble;

    @Before
    public void setUp() {
        this.primitiveMock = (IPrimitive)Mocks.createRelaxedMock(IPrimitive.class);
    }

    @Test
    public void testPrimitiveBooleanReturnType() {
        try {
            boolean value = this.primitiveMock.getBoolean();
            Assert.assertEquals((Object)uninitializedBoolean, (Object)value);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveBooleanSetLastReturnValue() {
        Boolean value = Boolean.TRUE;
        this.primitiveMock.getBoolean();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((Object)value, (Object)this.primitiveMock.getBoolean());
    }

    @Test
    public void testPrimitiveByteReturnType() {
        try {
            byte value = this.primitiveMock.getByte();
            Assert.assertEquals((long)unitializedByte, (long)value);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveByteSetLastReturnValue() {
        Byte value = 1;
        this.primitiveMock.getByte();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((long)value.byteValue(), (long)this.primitiveMock.getByte());
    }

    @Test
    public void testPrimitiveCharReturnType() {
        try {
            char value = this.primitiveMock.getChar();
            Assert.assertEquals((long)unitializedChar, (long)value);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveCharSetLastReturnValue() {
        Character value = Character.valueOf('a');
        this.primitiveMock.getChar();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((long)value.charValue(), (long)this.primitiveMock.getChar());
    }

    @Test
    public void testPrimitiveShortReturnType() {
        try {
            short value = this.primitiveMock.getShort();
            Assert.assertEquals((long)unitializedShort, (long)value);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveShortSetLastReturnValue() {
        Short value = 1;
        this.primitiveMock.getShort();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((long)value.shortValue(), (long)this.primitiveMock.getShort());
    }

    @Test
    public void testPrimitiveIntReturnType() {
        try {
            int value = this.primitiveMock.getInt();
            Assert.assertEquals((long)unitializedInt, (long)value);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveIntSetLastReturnValue() {
        Integer value = 1;
        this.primitiveMock.getInt();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((long)value.intValue(), (long)this.primitiveMock.getInt());
    }

    @Test
    public void testPrimitiveLongReturnType() {
        try {
            long value = this.primitiveMock.getLong();
            Assert.assertEquals((long)unitializedLong, (long)value);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveLongSetLastReturnValue() {
        Long value = 1L;
        this.primitiveMock.getLong();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((long)value, (long)this.primitiveMock.getLong());
    }

    @Test
    public void testPrimitiveFloatReturnType() {
        try {
            float value = this.primitiveMock.getFloat();
            Assert.assertEquals((float)unitializedFloat, (float)value, (float)0.0f);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveFloatSetLastReturnValue() {
        Float value = Float.valueOf(1.0f);
        this.primitiveMock.getFloat();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((float)value.floatValue(), (float)this.primitiveMock.getFloat(), (float)0.0f);
    }

    @Test
    public void testPrimitiveDoubleReturnType() {
        try {
            double value = this.primitiveMock.getDouble();
            Assert.assertEquals((double)unitializedDouble, (double)value, (double)0.0);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Assert.fail((String)"exception should not have been thrown");
        }
    }

    @Test
    public void testPrimitiveDoubleSetLastReturnValue() {
        Double value = 1.0;
        this.primitiveMock.getDouble();
        Mocks.setLastReturnValue(this.primitiveMock, value);
        Mocks.startChecking(this.primitiveMock);
        Assert.assertEquals((double)value, (double)this.primitiveMock.getDouble(), (double)0.0);
    }

    public static interface IPrimitive {
        public boolean getBoolean();

        public byte getByte();

        public char getChar();

        public short getShort();

        public int getInt();

        public long getLong();

        public float getFloat();

        public double getDouble();
    }
}

