/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.harness.util.UITestCase;
import org.eclipse.ui.tests.internal.util.VerifyDialog;
import org.junit.Assert;

public class DialogCheck {
    private static VerifyDialog _verifyDialog;

    private DialogCheck() {
    }

    @Deprecated
    public static void assertDialog(Dialog dialog, junit.framework.Assert assertion) {
        DialogCheck.assertDialog(dialog);
    }

    public static void assertDialog(Dialog dialog) {
        Assert.assertNotNull((Object)dialog);
        if (_verifyDialog.getShell() == null) {
            DialogCheck.getShell();
        }
        if (_verifyDialog.open(dialog) == 3) {
            Assert.assertTrue((String)_verifyDialog.getFailureText(), (boolean)false);
        }
    }

    @Deprecated
    public static void assertDialogTexts(Dialog dialog, junit.framework.Assert assertion) {
        DialogCheck.assertDialogTexts(dialog);
    }

    public static void assertDialogTexts(Dialog dialog) {
        Assert.assertNotNull((Object)dialog);
        dialog.setBlockOnOpen(false);
        dialog.open();
        Shell shell = dialog.getShell();
        UITestCase.processEvents();
        DialogCheck.verifyCompositeText((Composite)shell);
        dialog.close();
        _verifyDialog.buttonPressed(2);
    }

    public static Shell getShell() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        _verifyDialog = new VerifyDialog(shell);
        _verifyDialog.create();
        return _verifyDialog.getShell();
    }

    private static void verifyCompositeText(Composite composite) {
        Control[] children;
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof TabFolder) {
                TabFolder folder = (TabFolder)child;
                int numPages = folder.getItemCount();
                int j = 0;
                while (j < numPages) {
                    folder.setSelection(j);
                    ++j;
                }
            } else if (child instanceof Button) {
                DialogCheck.verifyButtonText((Button)child);
            } else if (child instanceof Label) {
                DialogCheck.verifyLabelText((Label)child);
            } else if (child instanceof Composite) {
                DialogCheck.verifyCompositeText((Composite)child);
            }
            ++n2;
        }
    }

    private static void verifyButtonText(Button button) {
        String widget = button.toString();
        Point size = button.getSize();
        Point preferred = button.computeSize(-1, -1);
        if (preferred.y * size.y > 0) {
            preferred.y /= DialogCheck.countLines(button.getText());
            if (size.y / preferred.y > 1) {
                preferred.x /= size.y / preferred.y;
            }
        }
        String message = "Warning: " + widget + "\n\tActual Width -> " + size.x + "\n\tRecommended Width -> " + preferred.x;
        if (preferred.x > size.x) {
            button.getShell().dispose();
            Assert.assertTrue((String)message.toString(), (boolean)false);
        }
    }

    private static void verifyLabelText(Label label) {
        if (!label.isVisible()) {
            return;
        }
        String widget = label.toString();
        Point size = label.getSize();
        String labelText = label.getText();
        if (labelText == null || labelText.length() == 0) {
            return;
        }
        Point preferred = label.computeSize(-1, -1);
        if (preferred.y * size.y > 0) {
            preferred.y /= DialogCheck.countLines(label.getText());
            if (size.y / preferred.y > 1) {
                preferred.x /= size.y / preferred.y;
            }
        }
        String message = "Warning: " + widget + "\n\tActual Width -> " + size.x + "\n\tRecommended Width -> " + preferred.x;
        if (preferred.x > size.x) {
            label.getShell().dispose();
            Assert.assertTrue((String)message.toString(), (boolean)false);
        }
    }

    private static int countLines(String text) {
        int newLines = 1;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                ++newLines;
            }
            ++i;
        }
        return newLines;
    }
}

