/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.tests.harness.util.DisplayWaiter;

public abstract class DisplayHelper {
    protected DisplayHelper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean waitForCondition(Display display, long timeout) {
        if (this.condition()) {
            return true;
        }
        if (timeout < 0L) {
            return false;
        }
        DisplayHelper.driveEventQueue(display);
        if (this.condition()) {
            return true;
        }
        if (timeout == 0L) {
            return false;
        }
        DisplayWaiter waiter = new DisplayWaiter(display);
        DisplayWaiter.Timeout timeoutState = waiter.start(timeout);
        try {
            boolean condition;
            do {
                if (display.sleep()) {
                    DisplayHelper.driveEventQueue(display);
                }
                if (condition = this.condition()) return condition;
            } while (!timeoutState.hasTimedOut());
            return condition;
        }
        finally {
            waiter.stop();
        }
    }

    public static void sleep(long millis) {
        DisplayHelper.sleep(Display.getCurrent(), millis);
    }

    public static void sleep(Display display, long millis) {
        new DisplayHelper(){

            @Override
            public boolean condition() {
                return false;
            }
        }.waitForCondition(display, millis);
    }

    public static boolean runEventLoop(Display display, long timeout) {
        if (timeout < 0L) {
            return false;
        }
        if (timeout == 0L) {
            return DisplayHelper.driveEventQueue(display);
        }
        DisplayWaiter waiter = new DisplayWaiter(display);
        DisplayWaiter.Timeout timeoutState = waiter.start(timeout);
        boolean events = false;
        if (display.sleep() && !timeoutState.hasTimedOut()) {
            DisplayHelper.driveEventQueue(display);
            events = true;
        }
        waiter.stop();
        return events;
    }

    protected abstract boolean condition();

    private static boolean driveEventQueue(Display display) {
        boolean events = false;
        while (display.readAndDispatch()) {
            events = true;
        }
        return events;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean waitForCondition(Display display, long timeout, long interval) {
        if (this.condition()) {
            return true;
        }
        if (timeout < 0L) {
            return false;
        }
        DisplayHelper.driveEventQueue(display);
        if (this.condition()) {
            return true;
        }
        if (timeout == 0L) {
            return false;
        }
        DisplayWaiter waiter = new DisplayWaiter(display, true);
        long currentTimeMillis = System.currentTimeMillis();
        long finalTimeout = timeout + currentTimeMillis;
        if (finalTimeout < currentTimeMillis) {
            finalTimeout = Long.MAX_VALUE;
        }
        try {
            boolean condition;
            do {
                waiter.restart(interval);
                if (display.sleep()) {
                    DisplayHelper.driveEventQueue(display);
                }
                if (condition = this.condition()) return condition;
            } while (finalTimeout > System.currentTimeMillis());
            return condition;
        }
        finally {
            waiter.stop();
        }
    }
}

