/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;

public class Mocks {
    private static EqualityComparator defaultEqualityComparator = (o1, o2) -> o1 == null ? o2 == null : o1.equals(o2);
    private static EqualityComparator indifferentEqualityComparator = (o1, o2) -> true;
    private static Method getMockInvocationHandlerMethod;
    private static Method equalsMethod;

    static {
        try {
            getMockInvocationHandlerMethod = Mock.class.getMethod("getMockInvocationHandler", new Class[0]);
            equalsMethod = Object.class.getMethod("equals", Object.class);
        }
        catch (Exception exception) {}
    }

    public static <T> Object createRelaxedMock(Class<T> interfaceType) {
        return Mocks.createMock(interfaceType, false, indifferentEqualityComparator);
    }

    public static <T> Object createOrderedMock(Class<T> interfaceType) {
        return Mocks.createMock(interfaceType, true, indifferentEqualityComparator);
    }

    public static <T> Object createMock(Class<T> interfaceType) {
        return Mocks.createMock(interfaceType, true, defaultEqualityComparator);
    }

    public static <T> Object createMock(Class<T> interfaceType, EqualityComparator equalityComparator) {
        return Mocks.createMock(interfaceType, true, equalityComparator);
    }

    private static <T> Object createMock(Class<T> interfaceType, boolean ordered, EqualityComparator equalityComparator) {
        if (!interfaceType.isInterface()) {
            throw new IllegalArgumentException();
        }
        MockInvocationHandler mockInvocationHandler = new MockInvocationHandler(ordered, equalityComparator);
        Object newProxyInstance = Proxy.newProxyInstance(Mocks.class.getClassLoader(), new Class[]{interfaceType, Mock.class}, (InvocationHandler)mockInvocationHandler);
        return newProxyInstance;
    }

    public static void startChecking(Object mock) {
        Mocks.getMockInvocationHandler(mock).replay();
    }

    public static void verify(Object mock) {
        Mocks.getMockInvocationHandler(mock).verify();
    }

    public static void reset(Object mock) {
        Mocks.getMockInvocationHandler(mock).reset();
    }

    private static MockInvocationHandler getMockInvocationHandler(Object mock) {
        return ((Mock)mock).getMockInvocationHandler();
    }

    public static void setLastReturnValue(Object mock, Object object) {
        Mocks.getMockInvocationHandler(mock).setLastReturnValue(object);
    }

    public static interface EqualityComparator {
        public boolean equals(Object var1, Object var2);
    }

    private static interface Mock {
        public MockInvocationHandler getMockInvocationHandler();
    }

    private static final class MockInvocationHandler
    implements InvocationHandler {
        List<MethodCall> previousCallHistory = null;
        List<MethodCall> currentCallHistory = new ArrayList<MethodCall>();
        private final boolean ordered;
        private final EqualityComparator equalityComparator;

        public MockInvocationHandler(boolean ordered, EqualityComparator equalityComparator) {
            this.ordered = ordered;
            this.equalityComparator = equalityComparator;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (getMockInvocationHandlerMethod.equals(method)) {
                return this;
            }
            if (equalsMethod.equals(method)) {
                return proxy == args[0];
            }
            MethodCall methodCall = new MethodCall(method, args);
            if (this.previousCallHistory != null) {
                int indexOfMethodCall = this.previousCallHistory.indexOf(methodCall);
                if (indexOfMethodCall == -1) {
                    throw new AssertionFailedError("unexpected method call: " + method.getName());
                }
                methodCall.setReturnValue(this.previousCallHistory.get(indexOfMethodCall).getReturnValue());
                if (this.ordered) {
                    if (this.previousCallHistory.size() <= this.currentCallHistory.size()) {
                        throw new AssertionFailedError("extra method call: " + method.getName());
                    }
                    MethodCall previousCall = this.previousCallHistory.get(this.currentCallHistory.size());
                    if (!methodCall.equals(previousCall)) {
                        throw new AssertionFailedError("different method call (expected:" + previousCall.method.getName() + ", actual:" + method.getName() + ")");
                    }
                }
            }
            this.currentCallHistory.add(methodCall);
            Class<?> returnType = method.getReturnType();
            if (returnType.isPrimitive() && Void.TYPE != returnType) {
                Comparable<Boolean> result = null;
                Object returnValue = methodCall.getReturnValue();
                if (returnType == Boolean.TYPE) {
                    result = returnValue != null ? (Boolean)returnValue : Boolean.FALSE;
                } else if (returnType == Byte.TYPE) {
                    result = returnValue != null ? (Byte)returnValue : Byte.valueOf((byte)0);
                } else if (returnType == Character.TYPE) {
                    result = returnValue != null ? (Character)returnValue : Character.valueOf('\u0000');
                } else if (returnType == Short.TYPE) {
                    result = returnValue != null ? (Short)returnValue : Short.valueOf((short)0);
                } else if (returnType == Integer.TYPE) {
                    result = returnValue != null ? (Integer)returnValue : Integer.valueOf(0);
                } else if (returnType == Long.TYPE) {
                    result = returnValue != null ? (Long)returnValue : Long.valueOf(0L);
                } else if (returnType == Float.TYPE) {
                    result = returnValue != null ? (Float)returnValue : Float.valueOf(0.0f);
                } else if (returnType == Double.TYPE) {
                    result = returnValue != null ? (Double)returnValue : Double.valueOf(0.0);
                }
                return result;
            }
            return methodCall.getReturnValue();
        }

        public void replay() {
            this.previousCallHistory = this.currentCallHistory;
            this.currentCallHistory = new ArrayList<MethodCall>();
        }

        public void verify() {
            if (this.previousCallHistory == null) {
                if (this.currentCallHistory.isEmpty()) {
                    return;
                }
                throw new AssertionFailedError("unexpected");
            }
            if (this.ordered) {
                int numMissingCalls = this.previousCallHistory.size() - this.currentCallHistory.size();
                if (numMissingCalls > 0) {
                    throw new AssertionFailedError("missing method calls (" + numMissingCalls + ", first is: " + this.previousCallHistory.get(this.currentCallHistory.size()) + ")");
                }
                int i = 0;
                while (i < this.previousCallHistory.size()) {
                    if (!this.previousCallHistory.get(i).equals(this.currentCallHistory.get(i))) {
                        throw new AssertionFailedError("method call did not match (" + i + " of " + this.currentCallHistory.size() + ")");
                    }
                    ++i;
                }
            } else {
                for (MethodCall methodCall : this.previousCallHistory) {
                    if (this.currentCallHistory.contains(methodCall)) continue;
                    throw new AssertionFailedError("missing method call:" + methodCall.method.getName());
                }
            }
            this.reset();
        }

        public void reset() {
            this.previousCallHistory = null;
            this.currentCallHistory = new ArrayList<MethodCall>();
        }

        public void setLastReturnValue(Object object) {
            MethodCall methodCall = this.currentCallHistory.get(this.currentCallHistory.size() - 1);
            methodCall.setReturnValue(object);
        }

        private class MethodCall {
            private final Method method;
            private final Object[] args;
            private Object returnValue = null;

            public MethodCall(Method method, Object[] args) {
                this.method = method;
                this.args = args;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof MethodCall)) {
                    return false;
                }
                MethodCall other = (MethodCall)obj;
                if (other.method != this.method || other.args == null && this.args != null || other.args != null && this.args == null || this.args != null && other.args.length != this.args.length) {
                    return false;
                }
                if (this.args != null) {
                    int i = 0;
                    while (i < this.args.length) {
                        if (!MockInvocationHandler.this.equalityComparator.equals(this.args[i], other.args[i])) {
                            return false;
                        }
                        ++i;
                    }
                }
                return true;
            }

            public void setReturnValue(Object object) {
                this.returnValue = object;
            }

            public Object getReturnValue() {
                return this.returnValue;
            }

            public String toString() {
                return this.method.toString();
            }
        }
    }
}

