/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.DisplayAccess;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class RCPTestWorkbenchAdvisor
extends WorkbenchAdvisor {
    public static Boolean asyncDuringStartup = null;
    public static volatile Boolean syncWithDisplayAccess = null;
    public static volatile Boolean asyncWithDisplayAccess = null;
    public static volatile Boolean syncWithoutDisplayAccess = null;
    public static volatile Boolean asyncWithoutDisplayAccess = null;
    private static boolean started = false;
    private int idleBeforeExit = -1;
    private boolean windowlessApp = false;
    public static boolean displayAccessInUIThreadAllowed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSTARTED() {
        Class<RCPTestWorkbenchAdvisor> clazz = RCPTestWorkbenchAdvisor.class;
        synchronized (RCPTestWorkbenchAdvisor.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return started;
        }
    }

    public RCPTestWorkbenchAdvisor() {
        this.idleBeforeExit = -1;
    }

    public RCPTestWorkbenchAdvisor(int idleBeforeExit) {
        this.idleBeforeExit = idleBeforeExit;
    }

    public RCPTestWorkbenchAdvisor(boolean windowlessApp) {
        this.windowlessApp = windowlessApp;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        IPreferenceStore prefs = PlatformUI.getPreferenceStore();
        prefs.setValue("defaultPerspectiveId", "");
        prefs.setValue("SHOW_PROGRESS_ON_STARTUP", false);
        prefs.setValue("showIntro", false);
        if (this.windowlessApp) {
            configurer.setSaveAndRestore(true);
            configurer.setExitOnLastWindowClose(false);
        }
    }

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.ui.tests.harness.util.EmptyPerspective";
    }

    public void eventLoopIdle(Display display) {
        if (this.idleBeforeExit != -1 && --this.idleBeforeExit <= 0) {
            PlatformUI.getWorkbench().close();
        }
        if (this.idleBeforeExit == -1) {
            return;
        }
    }

    public void preStartup() {
        super.preStartup();
        Display display = Display.getCurrent();
        if (display != null) {
            display.asyncExec(() -> {
                asyncDuringStartup = RCPTestWorkbenchAdvisor.isSTARTED() ? Boolean.FALSE : Boolean.TRUE;
            });
        }
        this.setupAsyncDisplayThread(true, display);
        this.setupSyncDisplayThread(true, display);
        this.setupAsyncDisplayThread(false, display);
        this.setupSyncDisplayThread(false, display);
        try {
            DisplayAccess.accessDisplayDuringStartup();
            displayAccessInUIThreadAllowed = true;
        }
        catch (IllegalStateException illegalStateException) {
            displayAccessInUIThreadAllowed = false;
        }
    }

    private void setupSyncDisplayThread(final boolean callDisplayAccess, final Display display) {
        Thread syncThread = new Thread(){

            @Override
            public void run() {
                if (callDisplayAccess) {
                    DisplayAccess.accessDisplayDuringStartup();
                }
                try {
                    display.syncExec(() -> {
                        Class<RCPTestWorkbenchAdvisor> clazz = RCPTestWorkbenchAdvisor.class;
                        synchronized (RCPTestWorkbenchAdvisor.class) {
                            if (callDisplayAccess) {
                                syncWithDisplayAccess = !RCPTestWorkbenchAdvisor.isSTARTED() ? Boolean.TRUE : Boolean.FALSE;
                            } else {
                                syncWithoutDisplayAccess = !RCPTestWorkbenchAdvisor.isSTARTED() ? Boolean.TRUE : Boolean.FALSE;
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    });
                }
                catch (SWTException sWTException) {}
            }
        };
        syncThread.setDaemon(true);
        syncThread.start();
    }

    private void setupAsyncDisplayThread(final boolean callDisplayAccess, final Display display) {
        Thread asyncThread = new Thread(){

            @Override
            public void run() {
                if (callDisplayAccess) {
                    DisplayAccess.accessDisplayDuringStartup();
                }
                display.asyncExec(() -> {
                    Class<RCPTestWorkbenchAdvisor> clazz = RCPTestWorkbenchAdvisor.class;
                    synchronized (RCPTestWorkbenchAdvisor.class) {
                        if (callDisplayAccess) {
                            asyncWithDisplayAccess = !RCPTestWorkbenchAdvisor.isSTARTED() ? Boolean.TRUE : Boolean.FALSE;
                        } else {
                            asyncWithoutDisplayAccess = !RCPTestWorkbenchAdvisor.isSTARTED() ? Boolean.TRUE : Boolean.FALSE;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                });
            }
        };
        asyncThread.setDaemon(true);
        asyncThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postStartup() {
        super.postStartup();
        Class<RCPTestWorkbenchAdvisor> clazz = RCPTestWorkbenchAdvisor.class;
        synchronized (RCPTestWorkbenchAdvisor.class) {
            started = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

