/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.harness.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public abstract class UITestCase
extends TestCase {
    protected IWorkbench fWorkbench;
    private List<IWorkbenchWindow> testWindows = new ArrayList<IWorkbenchWindow>(3);
    private TestWindowListener windowListener;

    public static IAdaptable getPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public UITestCase(String testName) {
        super(testName);
    }

    public static void fail(String message, Throwable e) {
        if (e instanceof CoreException) {
            IStatus status = ((CoreException)e).getStatus();
            UITestCase.write(status, 0);
        } else {
            e.printStackTrace();
        }
        UITestCase.fail((String)(String.valueOf(message) + ": " + e));
    }

    private static void indent(OutputStream output, int indent) {
        int i = 0;
        while (i < indent) {
            try {
                output.write("\t".getBytes());
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    private static void write(IStatus status, int indent) {
        PrintStream output = System.out;
        UITestCase.indent(output, indent);
        output.println("Severity: " + status.getSeverity());
        UITestCase.indent(output, indent);
        output.println("Plugin ID: " + status.getPlugin());
        UITestCase.indent(output, indent);
        output.println("Code: " + status.getCode());
        UITestCase.indent(output, indent);
        output.println("Message: " + status.getMessage());
        if (status.getException() != null) {
            UITestCase.indent(output, indent);
            output.print("Exception: ");
            status.getException().printStackTrace(output);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                UITestCase.write(children[i], indent + 1);
                ++i;
            }
        }
    }

    private void addWindowListener() {
        this.windowListener = new TestWindowListener();
        this.fWorkbench.addWindowListener((IWindowListener)this.windowListener);
    }

    private void removeWindowListener() {
        if (this.windowListener != null) {
            this.fWorkbench.removeWindowListener((IWindowListener)this.windowListener);
        }
    }

    protected void trace(String msg) {
        System.out.println(msg);
    }

    protected final void setUp() throws Exception {
        super.setUp();
        this.fWorkbench = PlatformUI.getWorkbench();
        this.trace("----- " + this.getName());
        this.trace(String.valueOf(this.getName()) + ": setUp...");
        this.addWindowListener();
        this.doSetUp();
    }

    protected void doSetUp() throws Exception {
    }

    protected final void tearDown() throws Exception {
        this.trace(String.valueOf(this.getName()) + ": tearDown...\n");
        this.removeWindowListener();
        this.doTearDown();
        this.fWorkbench = null;
    }

    protected void doTearDown() throws Exception {
        UITestCase.processEvents();
        this.closeAllTestWindows();
        UITestCase.processEvents();
    }

    public static void processEvents() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public static void waitForJobs(long minTimeMs, long maxTimeMs) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < minTimeMs) {
            UITestCase.processEvents();
            UITestCase.sleep(10L);
        }
        while (!Job.getJobManager().isIdle() && System.currentTimeMillis() - start < maxTimeMs) {
            UITestCase.processEvents();
            UITestCase.sleep(10L);
        }
    }

    protected static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    protected boolean forceActive(Shell shell) {
        Shell s;
        Shell[] shells;
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            s = shellArray[n2];
            if (s.isVisible()) {
                s.setMinimized(true);
            }
            UITestCase.processEvents();
            ++n2;
        }
        UITestCase.waitForJobs(200L, 3000L);
        shellArray = shells;
        n = shells.length;
        n2 = 0;
        while (n2 < n) {
            s = shellArray[n2];
            if (s.isVisible()) {
                s.setMinimized(false);
            }
            UITestCase.processEvents();
            ++n2;
        }
        UITestCase.waitForJobs(200L, 3000L);
        shell.setVisible(false);
        UITestCase.processEvents();
        shell.setMinimized(true);
        UITestCase.processEvents();
        UITestCase.waitForJobs(200L, 3000L);
        shell.setVisible(true);
        UITestCase.processEvents();
        shell.setMinimized(false);
        UITestCase.processEvents();
        shell.forceActive();
        UITestCase.processEvents();
        shell.forceFocus();
        UITestCase.processEvents();
        UITestCase.waitForJobs(400L, 3000L);
        return display.getActiveShell() == shell;
    }

    protected boolean processEventsUntil(Condition condition, long timeout) {
        long startTime = System.currentTimeMillis();
        Display display = this.getWorkbench().getDisplay();
        while (condition == null || !condition.compute()) {
            if (timeout != -1L && System.currentTimeMillis() - startTime > timeout) {
                return false;
            }
            while (display.readAndDispatch()) {
            }
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public IWorkbenchWindow openTestWindow() {
        return this.openTestWindow("org.eclipse.ui.tests.harness.util.EmptyPerspective");
    }

    public IWorkbenchWindow openTestWindow(String perspectiveId) {
        try {
            IWorkbenchWindow window = this.fWorkbench.openWorkbenchWindow(perspectiveId, UITestCase.getPageInput());
            this.waitOnShell(window.getShell());
            return window;
        }
        catch (WorkbenchException e) {
            UITestCase.fail("Problem opening test window", e);
            return null;
        }
    }

    private void waitOnShell(Shell shell) {
        UITestCase.processEvents();
        UITestCase.waitForJobs(100L, 5000L);
    }

    public void closeAllTestWindows() {
        ArrayList<IWorkbenchWindow> testWindowsCopy = new ArrayList<IWorkbenchWindow>(this.testWindows);
        for (IWorkbenchWindow testWindow : testWindowsCopy) {
            testWindow.close();
        }
        this.testWindows.clear();
    }

    public IWorkbenchPage openTestPage(IWorkbenchWindow win) {
        IWorkbenchPage[] pages = this.openTestPage(win, 1);
        if (pages != null) {
            return pages[0];
        }
        return null;
    }

    public IWorkbenchPage[] openTestPage(IWorkbenchWindow win, int pageTotal) {
        try {
            IWorkbenchPage[] pages = new IWorkbenchPage[pageTotal];
            IAdaptable input = UITestCase.getPageInput();
            int i = 0;
            while (i < pageTotal) {
                pages[i] = win.openPage("org.eclipse.ui.tests.harness.util.EmptyPerspective", input);
                ++i;
            }
            return pages;
        }
        catch (WorkbenchException e) {
            UITestCase.fail("Problem opening test page", e);
            return null;
        }
    }

    public void closeAllPages(IWorkbenchWindow window) {
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            pages[i].close();
            ++i;
        }
    }

    protected void manageWindows(boolean manage) {
        this.windowListener.setEnabled(manage);
    }

    protected IWorkbench getWorkbench() {
        return this.fWorkbench;
    }

    protected static interface Condition {
        public boolean compute();
    }

    public static class ShellStateListener
    implements ShellListener {
        private AtomicBoolean shellIsActive;

        public ShellStateListener(AtomicBoolean shellIsActive) {
            this.shellIsActive = shellIsActive;
        }

        public void shellIconified(ShellEvent e) {
            this.shellIsActive.set(false);
        }

        public void shellDeiconified(ShellEvent e) {
            this.shellIsActive.set(true);
        }

        public void shellDeactivated(ShellEvent e) {
            this.shellIsActive.set(false);
        }

        public void shellClosed(ShellEvent e) {
            this.shellIsActive.set(false);
        }

        public void shellActivated(ShellEvent e) {
            this.shellIsActive.set(true);
        }
    }

    class TestWindowListener
    implements IWindowListener {
        private boolean enabled = true;

        TestWindowListener() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            if (this.enabled) {
                UITestCase.this.testWindows.remove(window);
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
            if (this.enabled) {
                UITestCase.this.testWindows.add(window);
            }
        }
    }
}

