/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.harness.util.SWTEventHelper;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestDragAssistant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DnDTest
extends NavigatorTestBase {
    public DnDTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestView";
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void testBasicDragDrop() {
        this._viewer.expandToLevel((Object)this._p1, 3);
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._p1.getFolder("f1").getFile("file1.txt")));
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem start = items[0].getItem(0).getItem(0);
        TreeItem end = items[0].getItem(1);
        if (!SWTEventHelper.performDnD((Widget)start, (Widget)end)) {
            System.out.println("Drag and drop failed - test invalid");
            return;
        }
        this._viewer.expandToLevel((Object)this._p1, 3);
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)this._p1.getFolder("f1").getFile("file2.txt"), (Object)items[0].getItem(0).getItem(0).getData());
        Assert.assertEquals((Object)this._p1.getFolder("f2").getFile("file1.txt"), (Object)items[0].getItem(1).getItem(0).getData());
        Assert.assertFalse((boolean)this._p1.getFolder("f1").getFile("file1.txt").exists());
        Assert.assertTrue((boolean)this._p1.getFolder("f2").getFile("file1.txt").exists());
    }

    @Test
    public void testResourceDrag() {
        this._viewer.expandToLevel((Object)this._p1, 3);
        IFile file = this._p1.getFolder("f1").getFile("file1.txt");
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)file));
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TextEditor editorPart = null;
        try {
            editorPart = (TextEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        }
        catch (PartInitException partInitException) {
            Assert.fail((String)"Should not throw an exception");
        }
        Control end = (Control)editorPart.getAdapter(Control.class);
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem start = items[0].getItem(0).getItem(0);
        if (!SWTEventHelper.performDnD((Widget)start, (Widget)end)) {
            System.out.println("Drag and drop failed - test invalid");
            return;
        }
        Assert.assertNotNull((Object)TestDragAssistant._finishedEvent);
        Assert.assertNotNull((Object)TestDragAssistant._finishedSelection);
    }

    @Test
    public void testDragOptOut() {
        this._viewer.expandToLevel((Object)this._p1, 3);
        IFile file = this._p1.getFolder("f1").getFile("file1.txt");
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)file));
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TextEditor editorPart = null;
        try {
            editorPart = (TextEditor)IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
        }
        catch (PartInitException partInitException) {
            Assert.fail((String)"Should not throw an exception");
        }
        Control end = (Control)editorPart.getAdapter(Control.class);
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem start = items[0].getItem(0).getItem(0);
        TestDragAssistant._doit = false;
        if (!SWTEventHelper.performDnD((Widget)start, (Widget)end)) {
            System.out.println("Drag and drop failed - test invalid");
            return;
        }
        Assert.assertFalse((boolean)TestDragAssistant._dragSetDataCalled);
    }

    @Test
    public void testSetDragOperation() {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentDropCopy"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentDropCopy"}, false);
        this._viewer.expandToLevel((Object)this._p1, 3);
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._p1.getFolder("f1").getFile("file1.txt")));
        DisplayHelper.sleep((long)100L);
        TreeItem[] items = this._viewer.getTree().getItems();
        int firstFolder = 0;
        TreeItem start = items[0].getItem(firstFolder).getItem(0);
        TreeItem end = items[0].getItem(firstFolder + 1);
        if (!SWTEventHelper.performDnD((Widget)start, (Widget)end)) {
            System.out.println("Drag and drop failed - test invalid");
            return;
        }
        this.refreshViewer();
        DisplayHelper.sleep((long)100L);
        this._viewer.expandToLevel((Object)this._p1, 3);
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)this._p1.getFolder("f1").getFile("file1.txt"), (Object)items[0].getItem(firstFolder).getItem(0).getData());
        Assert.assertEquals((Object)this._p1.getFolder("f1").getFile("file2.txt"), (Object)items[0].getItem(firstFolder).getItem(1).getData());
        Assert.assertEquals((Object)this._p1.getFolder("f2").getFile("file1.txt"), (Object)items[0].getItem(firstFolder + 1).getItem(0).getData());
        Assert.assertTrue((boolean)this._p1.getFolder("f1").getFile("file1.txt").exists());
        Assert.assertTrue((boolean)this._p1.getFolder("f2").getFile("file1.txt").exists());
    }
}

