/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.junit.Assert;
import org.junit.Test;

public class FilterTest
extends NavigatorTestBase {
    private static final String TEST_FILTER_ACTIVE_NOT_VISIBLE = "org.eclipse.ui.tests.navigator.filters.nonvisibleactive";

    public FilterTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.FilterTestView";
    }

    @Test
    public void testFilterActivation() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((long)3L, (long)items.length);
        NavigatorContentService ncs = (NavigatorContentService)this._contentService;
        Assert.assertEquals((long)0L, (long)ncs.getContributionMemorySize());
        this._contentService.getFilterService().activateFilterIdsAndUpdateViewer(new String[]{"org.eclipse.ui.tests.navigator.filters.p1", "org.eclipse.ui.tests.navigator.filters.p2"});
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((long)1L, (long)items.length);
        Assert.assertEquals((Object)"Test", (Object)items[0].getText());
        Assert.assertEquals((long)0L, (long)ncs.getContributionMemorySize());
        this._contentService.getFilterService().activateFilterIdsAndUpdateViewer(new String[]{"org.eclipse.ui.tests.navigator.filters.p1"});
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((long)2L, (long)items.length);
        Assert.assertEquals((Object)"p2", (Object)items[0].getText());
        Assert.assertEquals((long)0L, (long)ncs.getContributionMemorySize());
        this._contentService.getFilterService().activateFilterIdsAndUpdateViewer(new String[0]);
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((long)3L, (long)items.length);
        Assert.assertEquals((Object)"p1", (Object)items[0].getText());
        Assert.assertEquals((Object)"p2", (Object)items[1].getText());
        Assert.assertEquals((long)0L, (long)ncs.getContributionMemorySize());
    }

    @Test
    public void testNonVisibleFilters() {
        this._contentService.getFilterService().persistFilterActivationState();
        NavigatorFilterService filterService = new NavigatorFilterService((NavigatorContentService)this._contentService);
        Assert.assertTrue((boolean)filterService.isActive(TEST_FILTER_ACTIVE_NOT_VISIBLE));
    }
}

