/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestEmptyContentProvider;
import org.eclipse.ui.tests.navigator.extension.TestLabelProvider;
import org.eclipse.ui.tests.navigator.extension.TestLabelProviderBlank;
import org.eclipse.ui.tests.navigator.extension.TestLabelProviderCyan;
import org.eclipse.ui.tests.navigator.extension.TestLabelProviderStyledGreen;
import org.eclipse.ui.tests.navigator.extension.TrackingLabelProvider;
import org.junit.Assert;
import org.junit.Test;

public class LabelProviderTest
extends NavigatorTestBase {
    private static final boolean PRINT_DEBUG_INFO = false;
    private static final boolean SLEEP_LONG = false;
    private static final int NONE = 0;
    private static final int OVERRIDDEN = 1;
    private static final int OVERRIDING = 2;
    private static final int BOTH = 3;
    private static final boolean BLANK = true;
    private static final boolean NULL = false;
    private static final String PLAIN = "Plain";

    public LabelProviderTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.OverrideTestView";
    }

    private void setBlank(String cpToGet, boolean blank) {
        NavigatorContentExtension ext = (NavigatorContentExtension)this._contentService.getContentExtensionById(cpToGet);
        TestLabelProvider tp = (TestLabelProvider)ext.getLabelProvider();
        if (blank) {
            tp._blank = true;
        } else {
            tp._null = true;
        }
    }

    public void blankLabelProviderOverride(int nce, boolean blank, String suffix) throws Exception {
        String overriddenCp = "org.eclipse.ui.tests.navigator.testContentOverridden1" + suffix;
        String overrideCp = "org.eclipse.ui.tests.navigator.testContentOverride1" + suffix;
        String checkColor = "Green";
        switch (nce) {
            case 0: {
                break;
            }
            case 1: {
                this.setBlank(overriddenCp, blank);
                break;
            }
            case 2: {
                checkColor = "Red";
                this.setBlank(overrideCp, blank);
                break;
            }
            case 3: {
                this.setBlank(overriddenCp, blank);
                this.setBlank(overrideCp, blank);
            }
        }
        this._contentService.bindExtensions(new String[]{overriddenCp, overrideCp}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{overrideCp, overriddenCp}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        ILabelProvider lp = this._contentService.createCommonLabelProvider();
        String lpText = lp.getText(rootItems[0].getData());
        if (nce == 3) {
            if (!rootItems[0].getText().equals("")) {
                Assert.fail((String)("Wrong text: " + rootItems[0].getText()));
            }
            if (blank) {
                if (!lpText.equals("")) {
                    Assert.fail((String)("Wrong text from ILabelProvider: " + lpText));
                }
            } else if (lpText != null) {
                Assert.fail((String)("Wrong text from ILabelProvider: " + lpText));
            }
        } else {
            if (!rootItems[0].getText().startsWith(checkColor)) {
                Assert.fail((String)("Wrong text: " + rootItems[0].getText()));
            }
            if (!lpText.startsWith(checkColor)) {
                Assert.fail((String)("Wrong text from ILabelProvider: " + lpText));
            }
        }
    }

    @Test
    public void testBlankLabelProviderOverrideNone() throws Exception {
        this.blankLabelProviderOverride(0, true, "");
    }

    @Test
    public void testNullLabelProviderOverrideNone() throws Exception {
        this.blankLabelProviderOverride(0, false, "");
    }

    @Test
    public void testPlainBlankLabelProviderOverrideNone() throws Exception {
        this.blankLabelProviderOverride(0, true, PLAIN);
    }

    @Test
    public void testPlainNullLabelProviderOverrideNone() throws Exception {
        this.blankLabelProviderOverride(0, false, PLAIN);
    }

    @Test
    public void testBlankLabelProviderOverride1() throws Exception {
        this.blankLabelProviderOverride(1, true, "");
    }

    @Test
    public void testNullLabelProviderOverride1() throws Exception {
        this.blankLabelProviderOverride(1, false, "");
    }

    @Test
    public void testPlainBlankLabelProviderOverride1() throws Exception {
        this.blankLabelProviderOverride(1, true, PLAIN);
    }

    @Test
    public void testPlainNullLabelProviderOverride1() throws Exception {
        this.blankLabelProviderOverride(1, false, PLAIN);
    }

    @Test
    public void testBlankLabelProviderOverride2() throws Exception {
        this.blankLabelProviderOverride(2, true, "");
    }

    @Test
    public void testNullLabelProviderOverride2() throws Exception {
        this.blankLabelProviderOverride(2, false, "");
    }

    @Test
    public void testPlainBlankLabelProviderOverride2() throws Exception {
        this.blankLabelProviderOverride(2, true, PLAIN);
    }

    @Test
    public void testPlainNullLabelProviderOverride2() throws Exception {
        this.blankLabelProviderOverride(2, false, PLAIN);
    }

    @Test
    public void testBlankLabelProviderBoth() throws Exception {
        this.blankLabelProviderOverride(3, true, "");
    }

    @Test
    public void testNullLabelProviderBoth() throws Exception {
        this.blankLabelProviderOverride(3, false, "");
    }

    @Test
    public void testPlainBlankLabelProviderBoth() throws Exception {
        this.blankLabelProviderOverride(3, true, PLAIN);
    }

    @Test
    public void testPlainNullLabelProviderBoth() throws Exception {
        this.blankLabelProviderOverride(3, false, PLAIN);
    }

    @Test
    public void testSimpleResFirst() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden1", "org.eclipse.ui.tests.navigator.testContentOverride1"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverride1", "org.eclipse.ui.tests.navigator.testContentOverridden1"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderStyledGreen.instance);
    }

    @Test
    public void testOverrideChain() throws Exception {
        String[] EXTENSIONS = new String[]{"org.eclipse.ui.tests.navigator.testTrackingLabel.A", "org.eclipse.ui.tests.navigator.testTrackingLabel.B", "org.eclipse.ui.tests.navigator.testTrackingLabel.C", "org.eclipse.ui.tests.navigator.testTrackingLabel.D", "org.eclipse.ui.tests.navigator.testTrackingLabel.E", "org.eclipse.ui.tests.navigator.testTrackingLabel.F", "org.eclipse.ui.tests.navigator.testTrackingLabel.G"};
        this._contentService.bindExtensions(EXTENSIONS, true);
        this._contentService.getActivationService().activateExtensions(EXTENSIONS, true);
        this.refreshViewer();
        this._viewer.getTree().getItems();
        TrackingLabelProvider.resetQueries();
        DisplayHelper.sleep((long)200L);
        this.refreshViewer();
        DisplayHelper.sleep((long)200L);
        String queries = (String)TrackingLabelProvider.styledTextQueries.get(this._project);
        Assert.assertTrue((String)"F has the highest priority", (boolean)queries.startsWith("F"));
        this.assertBefore(queries, 'C', 'A');
        this.assertBefore(queries, 'B', 'A');
        this.assertBefore(queries, 'D', 'B');
        this.assertBefore(queries, 'E', 'D');
        this.assertBefore(queries, 'F', 'C');
        this.assertBefore(queries, 'G', 'C');
    }

    private void assertBefore(String queries, char firstChar, char secondChar) {
        boolean first = false;
        int LEN = queries.length();
        int i = 0;
        while (i < LEN) {
            char cur = queries.charAt(i);
            if (cur == firstChar) {
                first = true;
            }
            if (cur == secondChar) {
                Assert.assertTrue((String)("Failed to find " + firstChar + " before " + secondChar + " in " + queries), (boolean)first);
                return;
            }
            ++i;
        }
    }

    @Test
    public void testSimpleResLast() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderCyan.instance);
    }

    @Test
    public void testOverrideAdd() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, true);
        this.refreshViewer();
        this._viewer.expandToLevel((Object)this._project, 3);
        IFile f = this._project.getFile("newfile");
        this._viewer.add((Object)this._project, new Object[]{f});
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderCyan.instance);
    }

    @Test
    public void testChangeActivation() throws Exception {
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderStyledGreen.instance);
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, true);
        this._viewer.expandAll();
        int i = 0;
        while (i < 1200) {
            rootItems = this._viewer.getTree().getItems();
            if (rootItems[0].getBackground(0).equals((Object)TestLabelProviderCyan.instance.backgroundColor)) break;
            DisplayHelper.sleep((long)50L);
            ++i;
        }
        DisplayHelper.sleep((long)500L);
        rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderCyan.instance);
    }

    @Test
    public void testUsingOverriddenLabelProvider() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2Blank"}, true);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2Blank"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        if (!rootItems[0].getText().startsWith("Blue")) {
            Assert.fail((String)("Wrong text: " + rootItems[0].getText()));
        }
        this.checkItems(rootItems, TestLabelProviderBlank.instance, true, false);
    }

    @Test
    public void testMultiNceSameObject() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden1", "org.eclipse.ui.navigator.resourceContent"}, true);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden1", "org.eclipse.ui.navigator.resourceContent"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        if (!rootItems[0].getText().equals("p1")) {
            Assert.fail((String)("Wrong text: " + rootItems[0].getText()));
        }
    }

    @Test
    public void testLabelProviderPriority() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentEmpty", "org.eclipse.ui.navigator.resourceContent"}, true);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentEmpty", "org.eclipse.ui.navigator.resourceContent"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)TestLabelProviderCyan.instance.image, (Object)rootItems[0].getImage(0));
    }

    @Test
    public void testLabelProviderThrow() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentEmpty", "org.eclipse.ui.navigator.resourceContent"}, true);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentEmpty", "org.eclipse.ui.navigator.resourceContent"}, true);
        TestLabelProvider._throw = true;
        TestEmptyContentProvider._throw = true;
        this.refreshViewer();
    }
}

