/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestLinkHelper;
import org.junit.Assert;
import org.junit.Test;

public class LinkHelperTest
extends NavigatorTestBase {
    private static final int SLEEP_TIME = 800;
    private static final boolean SLEEP_LONG = false;

    public LinkHelperTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestLinkHelperView";
    }

    @Test
    public void testLinkHelperSelectionChange() throws Exception {
        System.out.println("SelectionChange start");
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IDE.openEditor((IWorkbenchPage)activePage, (IFile)this._p2.getFile("file1.txt"));
        IDE.openEditor((IWorkbenchPage)activePage, (IFile)this._p2.getFile("file2.txt"));
        this._commonNavigator.setLinkingEnabled(true);
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._p2.getFile("file1.txt")));
        DisplayHelper.sleep((long)800L);
        this._commonNavigator.getViewSite().getPage().activate((IWorkbenchPart)this._commonNavigator);
        System.out.println("before set 2");
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._p2.getFile("file2.txt")));
        DisplayHelper.sleep((long)800L);
        activePage.activate((IWorkbenchPart)this._commonNavigator);
        TestLinkHelper.instance.resetTest();
        System.out.println("before set 3");
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._p2.getFile("file1.txt")));
        DisplayHelper.sleep((long)800L);
        System.out.println("SelectionChange Done: " + TestLinkHelper.instance);
        Assert.assertEquals((long)0L, (long)TestLinkHelper.instance.findSelectionCount);
        Assert.assertEquals((long)1L, (long)TestLinkHelper.instance.activateEditorCount);
    }

    @Test
    public void testLinkHelperEditorActivation() throws Exception {
        System.out.println("EditorActivation start");
        this._commonNavigator.setLinkingEnabled(false);
        DisplayHelper.sleep((long)800L);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart file1Editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)this._p2.getFile("file1.txt"));
        IEditorPart file2Editor = IDE.openEditor((IWorkbenchPage)activePage, (IFile)this._p2.getFile("file2.txt"));
        this._commonNavigator.setLinkingEnabled(true);
        DisplayHelper.sleep((long)800L);
        TestLinkHelper.instance.resetTest();
        System.out.println("before activate 1");
        activePage.activate((IWorkbenchPart)file1Editor);
        DisplayHelper.sleep((long)800L);
        System.out.println("EditorActivation 1 Done: " + TestLinkHelper.instance);
        Assert.assertEquals((long)1L, (long)TestLinkHelper.instance.findSelectionCount);
        Assert.assertEquals((long)0L, (long)TestLinkHelper.instance.activateEditorCount);
        TestLinkHelper.instance.resetTest();
        System.out.println("before activate 2");
        activePage.activate((IWorkbenchPart)file2Editor);
        DisplayHelper.sleep((long)800L);
        System.out.println("EditorActivation 2 Done: " + TestLinkHelper.instance);
        Assert.assertEquals((long)1L, (long)TestLinkHelper.instance.findSelectionCount);
        Assert.assertEquals((long)0L, (long)TestLinkHelper.instance.activateEditorCount);
    }
}

