/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveFiltersOperation;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.junit.Assert;
import org.junit.Test;

public class OpenTest
extends NavigatorTestBase {
    public OpenTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestView";
    }

    @Test
    public void testNavigatorRootContents() throws Exception {
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        UpdateActiveFiltersOperation updateFilters = new UpdateActiveFiltersOperation(this._viewer, new String[0]);
        updateFilters.execute(null, null);
        this.refreshViewer();
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be some items.", (items.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this._project, (Object)items[2].getData());
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._project.getFile(".project")));
        TreeItem[] children = items[2].getItems();
        Assert.assertEquals((long)this._expectedChildren.size(), (long)children.length);
        int i = 0;
        while (i < children.length) {
            Assert.assertTrue((boolean)this._expectedChildren.contains(children[i].getData()));
            ++i;
        }
    }

    @Test
    public void testNavigatorExtensionEnablement() throws Exception {
        this._contentService.getActivationService().activateExtensions(new String[0], true);
        this.refreshViewer();
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be NO items.", (items.length == 0 ? 1 : 0) != 0);
        this._contentService.getActivationService().deactivateExtensions(new String[0], true);
        this._viewer.expandToLevel(2);
        items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be some items.", (items.length > 0 ? 1 : 0) != 0);
    }
}

