/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.sorters.CommonSorterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestComparatorData;
import org.eclipse.ui.tests.navigator.extension.TestContentProvider;
import org.eclipse.ui.tests.navigator.extension.TestContentProviderResource;
import org.eclipse.ui.tests.navigator.extension.TestExtensionTreeData;
import org.eclipse.ui.tests.navigator.extension.TestSorterDataAndResource;
import org.eclipse.ui.tests.navigator.extension.TestSorterResource;
import org.junit.Assert;
import org.junit.Test;

public class SorterTest
extends NavigatorTestBase {
    private int _statusCount;

    public SorterTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestView";
    }

    @Test
    public void testSorterMissing() throws Exception {
        TestContentProviderResource._returnBadObject = true;
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel"}, true);
        this.refreshViewer();
        ILogListener ll = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                SorterTest sorterTest = SorterTest.this;
                sorterTest._statusCount = sorterTest._statusCount + 1;
            }
        };
        NavigatorPlugin.getDefault().getLog().addLogListener(ll);
        this._viewer.expandAll();
        NavigatorPlugin.getDefault().getLog().removeLogListener(ll);
        Assert.assertTrue((String)("Status Count: " + this._statusCount), (this._statusCount == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSorterProperty() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource"}, true);
        this.refreshViewer();
        this._viewer.update((Object)this._p1, new String[]{"prop1"});
        this._viewer.expandAll();
        Assert.assertEquals((Object)"prop1", (Object)TestSorterResource._sorterProperty);
        Assert.assertEquals((Object)this._p1, (Object)TestSorterResource._sorterElement);
    }

    protected void dynamicAddModelObjects() throws Exception {
        this._viewer.setExpandedState((Object)this._project, true);
        Properties props = new Properties();
        props.put("AddedParent", "Child1,AddedChild1");
        TestExtensionTreeData newData = new TestExtensionTreeData(TestContentProvider._modelRoot, "AddedParent", props, null);
        this._viewer.add((Object)this._project, (Object)newData);
        this._viewer.setExpandedState((Object)newData, true);
        IFile file = this._project.getFile("AddedFile1.txt");
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        this._viewer.add((Object)newData, (Object)file);
        file = this._project.getFile("AddedFile2.txt");
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        this._viewer.add((Object)newData, (Object)file);
    }

    public void DISABLED_testSorterContentOverride() throws Exception {
        TreeItem[] childItems;
        this.waitForModelObjects();
        INavigatorContentDescriptor desc = this._contentService.getContentDescriptorById("org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly");
        TestSorterResource sorter = (TestSorterResource)this._contentService.getSorterService().findSorter(desc, (Object)this._project, null, null);
        sorter._forward = false;
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly"}, false);
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)"p2", (Object)items[0].getText());
        Assert.assertEquals((Object)"p1", (Object)items[1].getText());
        Assert.assertEquals((Object)"Test", (Object)items[2].getText());
        Assert.assertEquals((Object)"Bluefile6.txt", (Object)items[0].getItems()[0].getText());
        Assert.assertEquals((Object)"f2", (Object)items[1].getItems()[0].getText());
        this._contentService.getActivationService().deactivateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly"}, false);
        this.refreshViewer();
        this._viewer.expandAll();
        int count = 100;
        boolean passed = false;
        while (!passed) {
            items = this._viewer.getTree().getItems();
            Assert.assertEquals((Object)"p2", (Object)items[1].getText());
            Assert.assertEquals((Object)"p1", (Object)items[0].getText());
            Assert.assertEquals((Object)"Test", (Object)items[2].getText());
            childItems = items[1].getItems();
            if (!childItems[0].getText().equals("f1") && count-- >= 0) {
                System.out.println("Not equal: " + childItems[0].getText() + " waiting...");
                DisplayHelper.sleep((long)100L);
                continue;
            }
            Assert.assertEquals((Object)"f1", (Object)childItems[0].getText());
            childItems = items[0].getItems();
            Assert.assertEquals((Object)"f1", (Object)childItems[0].getText());
            passed = true;
        }
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly"}, false);
        this.refreshViewer();
        this._viewer.expandAll();
        count = 100;
        passed = false;
        while (!passed) {
            items = this._viewer.getTree().getItems();
            Assert.assertEquals((Object)"p2", (Object)items[0].getText());
            Assert.assertEquals((Object)"p1", (Object)items[1].getText());
            Assert.assertEquals((Object)"Test", (Object)items[2].getText());
            if (!items[0].getItems()[0].getText().equals("Bluefile6.txt") && count-- >= 0) {
                System.out.println("Not equal: " + items[0].getItems()[0].getText() + " waiting...");
                DisplayHelper.sleep((long)100L);
                continue;
            }
            Assert.assertEquals((Object)"Bluefile6.txt", (Object)items[0].getItems()[0].getText());
            Assert.assertEquals((Object)"f2", (Object)items[1].getItems()[0].getText());
            passed = true;
        }
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly.override"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly.override"}, false);
        this.refreshViewer();
        this._viewer.expandAll();
        count = 100;
        passed = false;
        while (!passed) {
            items = this._viewer.getTree().getItems();
            Assert.assertEquals((Object)"p2", (Object)items[2].getText());
            Assert.assertEquals((Object)"p1", (Object)items[1].getText());
            Assert.assertEquals((Object)"Test", (Object)items[0].getText());
            childItems = items[2].getItems();
            if (!childItems[0].getText().equals("f1") && count-- >= 0) {
                System.out.println("Not equal: " + childItems[0].getText() + " waiting...");
                DisplayHelper.sleep((long)100L);
                continue;
            }
            Assert.assertEquals((Object)"f1", (Object)childItems[0].getText());
            childItems = items[1].getItems();
            Assert.assertEquals((Object)"f1", (Object)childItems[0].getText());
            passed = true;
        }
    }

    @Test
    public void testSorterContentOverrideNoSort() throws Exception {
        this.waitForModelObjects();
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel.override.nosort"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel.override.nosort"}, false);
        INavigatorContentDescriptor desc = this._contentService.getContentDescriptorById("org.eclipse.ui.tests.navigator.testContentSorterModel.override");
        TestSorterDataAndResource sorter = (TestSorterDataAndResource)this._contentService.getSorterService().findSorter(desc, (Object)this._project, null, null);
        sorter._forward = false;
        this._viewer.setExpandedState((Object)this._project, true);
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem addedParent = items[2].getItem(0);
        this._viewer.setExpandedState(addedParent.getData(), true);
        Assert.assertEquals((Object)"BlueParent", (Object)addedParent.getText());
        Assert.assertEquals((Object)"BlueChild1", (Object)addedParent.getItem(0).getText());
        Assert.assertEquals((Object)"BlueChild2", (Object)addedParent.getItem(1).getText());
    }

    @Test
    public void testSorterContentAdd() throws Exception {
        this.waitForModelObjects();
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel"}, false);
        this.dynamicAddModelObjects();
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem addedParent = items[2].getItem(0);
        Assert.assertEquals((Object)"BlueAddedParent", (Object)addedParent.getText());
        Assert.assertEquals((Object)"BlueAddedChild1", (Object)addedParent.getItem(0).getText());
        Assert.assertEquals((Object)"BlueChild1", (Object)addedParent.getItem(1).getText());
        Assert.assertEquals((Object)"BlueAddedFile1.txt", (Object)addedParent.getItem(2).getText());
        Assert.assertEquals((Object)"BlueAddedFile2.txt", (Object)addedParent.getItem(3).getText());
    }

    @Test
    public void testComparatorAsSorter() throws Exception {
        this.waitForModelObjects();
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentComparatorModel"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentComparatorModel"}, false);
        this.dynamicAddModelObjects();
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem addedParent = items[2].getItem(0);
        Assert.assertEquals((Object)"BlueAddedParent", (Object)addedParent.getText());
        Assert.assertEquals((Object)"BlueAddedChild1", (Object)addedParent.getItem(0).getText());
        Assert.assertEquals((Object)"BlueChild1", (Object)addedParent.getItem(1).getText());
        Assert.assertEquals((Object)"BlueAddedFile1.txt", (Object)addedParent.getItem(2).getText());
        Assert.assertEquals((Object)"BlueAddedFile2.txt", (Object)addedParent.getItem(3).getText());
        INavigatorContentDescriptor desc = this._contentService.getContentDescriptorById("org.eclipse.ui.tests.navigator.testContentComparatorModel");
        ViewerSorter sorter = this._contentService.getSorterService().findSorter(desc, (Object)this._project, null, null);
        Assert.assertNotNull((Object)sorter);
        CommonSorterDescriptor.WrappedViewerComparator wrapper = (CommonSorterDescriptor.WrappedViewerComparator)sorter;
        TestComparatorData original = (TestComparatorData)wrapper.getWrappedComparator();
        Object[] dataArray = new Object[items.length];
        int i = 0;
        while (i < items.length) {
            Object data;
            TreeItem treeItem = items[i];
            dataArray[i] = data = treeItem.getData();
            Assert.assertEquals((long)original.category(data), (long)wrapper.category(data));
            Assert.assertEquals((Object)original.isSorterProperty(data, "true"), (Object)wrapper.isSorterProperty(data, "true"));
            Assert.assertEquals((Object)original.isSorterProperty(data, "false"), (Object)wrapper.isSorterProperty(data, "false"));
            Assert.assertEquals((long)original.compare((Viewer)this._viewer, data, items[0].getData()), (long)wrapper.compare((Viewer)this._viewer, data, items[0].getData()));
            Assert.assertEquals((Object)false, (Object)wrapper.isSorterProperty(data, "false"));
            Assert.assertEquals((Object)true, (Object)wrapper.isSorterProperty(data, "true"));
            ++i;
        }
        Object[] copy1 = Arrays.copyOf(dataArray, dataArray.length);
        Object[] copy2 = Arrays.copyOf(dataArray, dataArray.length);
        original._forward = !original._forward;
        original.sort((Viewer)this._viewer, copy1);
        wrapper.sort((Viewer)this._viewer, copy2);
        Assert.assertArrayEquals((Object[])copy1, (Object[])copy2);
        Assert.assertNotEquals((Object)copy1[0], (Object)dataArray[0]);
    }

    @Test
    public void testSorterContentAddOverride() throws Exception {
        this.waitForModelObjects();
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel.override"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterModel.override"}, false);
        this.dynamicAddModelObjects();
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem addedParent = items[2].getItem(3);
        Assert.assertEquals((Object)"BlueParent", (Object)addedParent.getText());
        addedParent = items[2].getItem(2);
        Assert.assertEquals((Object)"BlueAddedParent", (Object)addedParent.getText());
        Assert.assertEquals((Object)"BlueAddedChild1", (Object)addedParent.getItem(0).getText());
        Assert.assertEquals((Object)"BlueAddedFile1.txt", (Object)addedParent.getItem(1).getText());
        Assert.assertEquals((Object)"BlueAddedFile2.txt", (Object)addedParent.getItem(2).getText());
        Assert.assertEquals((Object)"BlueChild1", (Object)addedParent.getItem(3).getText());
    }

    @Test
    public void testSorterResource() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentSorterResource"}, true);
        this.refreshViewer();
        INavigatorContentDescriptor desc = this._contentService.getContentDescriptorById("org.eclipse.ui.tests.navigator.testContentSorterResource");
        TestSorterResource sorter = (TestSorterResource)this._contentService.getSorterService().findSorter(desc, (Object)this._p2, null, null);
        sorter._forward = false;
        IContainer cont = (IContainer)this._p2.members()[1];
        StructuredSelection sel = new StructuredSelection((Object)cont.members()[0]);
        this._viewer.setSelection((ISelection)sel);
        this._viewer.setExpandedState((Object)cont, true);
        TreeItem[] items = this._viewer.getTree().getItems();
        TreeItem file1 = items[2].getItem(0);
        Assert.assertEquals((Object)"file6.txt", (Object)file1.getText());
    }
}

