/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.cdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.tests.navigator.cdt.CContainer;
import org.eclipse.ui.tests.navigator.cdt.CNavigatorContentProvider;

public class CElement
implements IAdaptable {
    protected IResource _resource;
    protected CElement _parent;
    protected List _children;
    protected CNavigatorContentProvider _cp;

    public CElement(CNavigatorContentProvider cp, IResource resource, CElement parent) {
        this._cp = cp;
        this._resource = resource;
        cp._resourceToModel.put(this._resource, this);
        this._children = new ArrayList();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public IResource getResource() {
        return this._resource;
    }

    public void setResource(IResource Resource) {
        this._resource = Resource;
    }

    public String getElementName() {
        return "CElement: " + this._resource.getName();
    }

    public CElement getParent() {
        return this._parent;
    }

    public List getChildren() {
        try {
            if (this._children.isEmpty() && this._resource instanceof IContainer) {
                IResource[] members = ((IContainer)this._resource).members();
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IProject) {
                        this._children.add(members[i]);
                    } else if (members[i] instanceof IFolder) {
                        this._children.add(new CContainer(this._cp, members[i], this));
                    } else {
                        this._children.add(members[i]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return this._children;
    }

    public void addChild(CElement child) {
        if (!(child instanceof CContainer)) {
            this._children.add(child.getResource());
        } else {
            this._children.add(child);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IResource.class) {
            return adapter.cast(this._resource);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this._resource;
    }
}

