/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.dndtest;

import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PR263695 {
    public static void main(String[] args) {
        Display display = new Display();
        Listener listener = event -> {
            switch (event.type) {
                case 3: {
                    System.out.println("down");
                    break;
                }
                case 4: {
                    System.out.println("up");
                    break;
                }
                case 5: {
                    System.out.println("move");
                }
            }
        };
        display.addFilter(5, listener);
        display.addFilter(3, listener);
        display.addFilter(4, listener);
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Label label1 = new Label((Composite)shell, 2048);
        label1.setText("TEXT");
        Label label2 = new Label((Composite)shell, 2048);
        PR263695.setDragDrop(label1);
        PR263695.setDragDrop(label2);
        shell.setSize(200, 200);
        shell.open();
        Rectangle bounds = label1.getBounds();
        bounds = display.map((Control)label1.getParent(), null, bounds);
        int downX = bounds.x + bounds.width / 2;
        int downY = bounds.y + bounds.height / 2;
        bounds = label2.getBounds();
        bounds = display.map((Control)label2.getParent(), null, bounds);
        int upX = bounds.x + bounds.width / 2;
        int upY = bounds.y + bounds.height / 2;
        display.setCursorLocation(downX, downY);
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            int sleep = 50;
            Event event = new Event();
            event.type = 3;
            event.button = 1;
            display.post(event);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {}
            event = new Event();
            event.type = 5;
            event.x = downX;
            event.y = downY + 20;
            display.post(event);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {}
            System.out.println("move to target");
            event = new Event();
            event.type = 5;
            event.x = upX;
            event.y = upY;
            display.post(event);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {}
            System.out.println("move inside target");
            event = new Event();
            event.type = 5;
            event.x = upX;
            event.y = upY + 20;
            display.post(event);
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {}
            System.out.println("release");
            event = new Event();
            event.type = 4;
            event.button = 1;
            display.post(event);
        });
        t.start();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void setDragDrop(final Label label) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 7;
        DragSource source = new DragSource((Control)label, operations);
        source.setTransfer(types);
        source.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.doit = label.getText().length() != 0;
                System.out.println("dragStart: " + event);
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = label.getText();
            }

            public void dragFinished(DragSourceEvent event) {
                if (event.detail == 2) {
                    label.setText("");
                }
            }
        });
        DropTarget target = new DropTarget((Control)label, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                System.out.println("got event");
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                label.setText((String)event.data);
            }
        });
    }
}

