/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;

public class TestExtensionTreeData {
    private final Map<String, TestExtensionTreeData> children = new HashMap<String, TestExtensionTreeData>();
    private TestExtensionTreeData parent;
    private String name;
    private Properties model;
    private IFile container;

    public TestExtensionTreeData(TestExtensionTreeData aParent, String aName, Properties theModel, IFile aFile) {
        this.parent = aParent;
        this.name = aName;
        this.model = theModel;
        this.container = aFile;
    }

    public TestExtensionTreeData getParent() {
        return this.parent;
    }

    public TestExtensionTreeData[] getChildren() {
        String childrenString;
        HashSet<TestExtensionTreeData> updatedChildren = new HashSet<TestExtensionTreeData>();
        if (this.model != null && (childrenString = this.model.getProperty(this.getName())) != null) {
            String[] childrenElements = childrenString.split(",");
            int i = 0;
            while (i < childrenElements.length) {
                if (this.children.containsKey(childrenElements[i])) {
                    updatedChildren.add(this.children.get(childrenElements[i]));
                } else {
                    TestExtensionTreeData newChild = new TestExtensionTreeData(this, childrenElements[i], this.model, this.container);
                    this.children.put(newChild.getName(), newChild);
                    updatedChildren.add(newChild);
                }
                ++i;
            }
        }
        return updatedChildren.toArray(new TestExtensionTreeData[updatedChildren.size()]);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TestExtensionTreeData && ((TestExtensionTreeData)obj).getName().equals(this.name);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(this.getName()).append(":");
        toString.append("[");
        for (TestExtensionTreeData child : this.children.values()) {
            toString.append(child.toString());
        }
        toString.append("]");
        return toString.toString();
    }

    public IFile getFile() {
        return this.container;
    }
}

