/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.ui.tests.navigator.m12.ResourceWrapperContentProvider;
import org.eclipse.ui.tests.navigator.m12.model.M1Core;
import org.eclipse.ui.tests.navigator.m12.model.M1Project;
import org.eclipse.ui.tests.navigator.m12.model.ResourceWrapper;

public class TestPipelineProvider
extends ResourceWrapperContentProvider {
    public static final Map ELEMENTS = new HashMap();
    public static final Map CHILDREN = new HashMap();
    public static final Map ADDS = new HashMap();
    public static final Map REMOVES = new HashMap();
    public static final Map UPDATES = new HashMap();
    private String _id;

    @Override
    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        this._track(CHILDREN, aParent, this._id);
    }

    @Override
    public void getPipelinedElements(Object anInput, Set currentElements) {
        ArrayList<M1Project> newElements = new ArrayList<M1Project>();
        Iterator it = currentElements.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            IProject project = this.getProject(element);
            if (project == null) continue;
            M1Project m1Project = new M1Project(project);
            it.remove();
            newElements.add(m1Project);
        }
        currentElements.addAll(newElements);
        this._track(ELEMENTS, anInput, this._id);
    }

    public boolean hasPipelinedChildren(Object anInput, boolean currentHasChildren) {
        return currentHasChildren;
    }

    private IProject getProject(Object element) {
        if (element instanceof IProject) {
            return (IProject)element;
        }
        if (element instanceof IAdaptable) {
            return (IProject)((IAdaptable)element).getAdapter(IProject.class);
        }
        return null;
    }

    private void _track(Map map, Object key, String id) {
        if (key instanceof ResourceWrapper) {
            key = ((ResourceWrapper)key).getResource();
        }
        System.out.println("track:  " + TestPipelineProvider.mapName(map) + " " + key + " id: " + id);
        String queries = (String)map.get(key);
        StringBuilder buf = new StringBuilder(queries == null ? "" : queries);
        buf.append(id);
        map.put(key, buf.toString());
    }

    @Override
    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        Set children = anAddModification.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            this._track(ADDS, it.next(), this._id);
        }
        return super.interceptAdd(anAddModification);
    }

    @Override
    public boolean interceptRefresh(PipelinedViewerUpdate update) {
        Set targets = update.getRefreshTargets();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            this._track(UPDATES, it.next(), this._id);
        }
        return super.interceptRefresh(update);
    }

    @Override
    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        Set children = aRemoveModification.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            this._track(REMOVES, it.next(), this._id);
        }
        return super.interceptRemove(aRemoveModification);
    }

    @Override
    public boolean interceptUpdate(PipelinedViewerUpdate update) {
        Set targets = update.getRefreshTargets();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            this._track(UPDATES, it.next(), this._id);
        }
        return super.interceptUpdate(update);
    }

    @Override
    public void init(ICommonContentExtensionSite config) {
        this._id = config.getExtension().getId();
        int i = this._id.lastIndexOf(46);
        if (i >= 0) {
            this._id = this._id.substring(i + 1);
        }
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        try {
            this._track(CHILDREN, parentElement, String.valueOf(this._id) + "1");
            return ((ResourceWrapper)parentElement).getChildren();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return NO_CHILDREN;
        }
    }

    @Override
    public Object getParent(Object element) {
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {
        return false;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        this._track(ELEMENTS, inputElement, String.valueOf(this._id) + "1");
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    @Override
    public void restoreState(IMemento aMemento) {
    }

    @Override
    public void saveState(IMemento aMemento) {
    }

    @Override
    protected Object _convertToModelObject(Object object) {
        if (object instanceof IResource) {
            return M1Core.getModelObject((IResource)object);
        }
        return null;
    }

    public static String mapName(Map map) {
        if (map == ELEMENTS) {
            return "ELEMENTS";
        }
        if (map == CHILDREN) {
            return "CHILDREN";
        }
        if (map == ADDS) {
            return "ADDS";
        }
        if (map == REMOVES) {
            return "REMOVES";
        }
        if (map == UPDATES) {
            return "UPDATES";
        }
        return "??? unknown";
    }

    public static void reset() {
        ELEMENTS.clear();
        CHILDREN.clear();
        ADDS.clear();
        REMOVES.clear();
        UPDATES.clear();
    }
}

