/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.jst;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.tests.navigator.jst.CompressedJavaLibraries;
import org.eclipse.ui.tests.navigator.jst.ICompressedNode;
import org.eclipse.ui.tests.navigator.jst.WebJavaContentProvider;

public class CompressedJavaProject
implements ICompressedNode,
IAdaptable {
    private IProject project;
    private CompressedJavaLibraries compressedLibraries;

    public CompressedJavaProject(StructuredViewer viewer, IProject project) {
        this.project = project;
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.determineLabel();
    }

    public boolean isFlatteningSourceFolder() {
        return this.getNonExternalSourceFolders().size() == 1;
    }

    private String determineLabel() {
        List nonextSourceFolders = this.getNonExternalSourceFolders();
        Object singleRoot = null;
        if (nonextSourceFolders.size() == 1) {
            singleRoot = nonextSourceFolders.get(0);
        }
        return "Compressed Java resources: " + (singleRoot != null ? ": " + singleRoot.toString() : "");
    }

    public IProject getProject() {
        return this.project;
    }

    @Override
    public Object[] getChildren(ITreeContentProvider delegateContentProvider) {
        List nonExternalSourceFolders = this.getNonExternalSourceFolders();
        if (nonExternalSourceFolders.size() == 1) {
            Object[] sourceFolderChildren = delegateContentProvider.getChildren(nonExternalSourceFolders.get(0));
            nonExternalSourceFolders.clear();
            nonExternalSourceFolders.addAll(Arrays.asList(sourceFolderChildren));
        }
        nonExternalSourceFolders.add(this.getCompressedJavaLibraries());
        return nonExternalSourceFolders.toArray();
    }

    public List getNonExternalSourceFolders() {
        try {
            Object jProject = WebJavaContentProvider.javaCoreCreateProject((IResource)this.project);
            Method m = WebJavaContentProvider.IJAVA_PROJECT_CLASS.getMethod("getPackageFragmentRoots", new Class[0]);
            Object[] sourceFolders = (Object[])m.invoke(jProject, new Object[0]);
            return new ArrayList<Object>(Arrays.asList(sourceFolders));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompressedJavaLibraries getCompressedJavaLibraries() {
        if (this.compressedLibraries == null) {
            this.compressedLibraries = new CompressedJavaLibraries(this);
        }
        return this.compressedLibraries;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

