/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.jst;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.jst.WebJavaContentProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JstPipelineTest
extends NavigatorTestBase {
    private static final boolean SLEEP_LONG = false;

    public JstPipelineTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.PipelineTestView";
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        WebJavaContentProvider.staticInit(this._contentService.getContentExtensionById("org.eclipse.jdt.java.ui.javaContent").getContentProvider().getClass().getClassLoader());
    }

    @Test
    public void testJstPipeline() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.jdt.java.ui.javaContent", "org.eclipse.ui.tests.navigator.jst.ContentProvider"}, false);
        Assert.assertEquals((String)"There should be two visible extensions for the pipeline viewer.", (long)3L, (long)this._contentService.getVisibleExtensionIds().length);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.jdt.java.ui.javaContent", "org.eclipse.ui.tests.navigator.jst.ContentProvider"}, true);
        this.refreshViewer();
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._project.getFile(".project")), true);
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        Assert.assertEquals((String)("There should be " + _projectCount + " item(s)."), (long)_projectCount, (long)rootItems.length);
        Assert.assertTrue((String)"The root object should be an IJavaProject, which is IAdaptable.", (boolean)(rootItems[0].getData() instanceof IAdaptable));
        IProject adaptedProject = (IProject)((IAdaptable)rootItems[2].getData()).getAdapter(IProject.class);
        Assert.assertEquals((Object)this._project, (Object)adaptedProject);
        IFolder sourceFolder = this._project.getFolder((IPath)new Path("src"));
        this._viewer.add((Object)this._project, (Object)sourceFolder);
        TreeItem[] projectChildren = rootItems[2].getItems();
        boolean foundJava = false;
        boolean foundCompressedLibrary = false;
        boolean foundJavaLibrary = false;
        int i = 0;
        while (i < projectChildren.length) {
            if (projectChildren[i].getText().startsWith("Compressed Java")) {
                foundJava = true;
                this._viewer.setExpandedState(projectChildren[i].getData(), true);
                TreeItem[] srcChildren = projectChildren[i].getItems();
                int j = 0;
                while (j < srcChildren.length) {
                    if (srcChildren[j].getText().startsWith("Compressed Libraries")) {
                        foundCompressedLibrary = true;
                    }
                    if (srcChildren[j].getText().startsWith("charsets.jar") || srcChildren[j].getText().startsWith("java.base")) {
                        foundJavaLibrary = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        Assert.assertTrue((boolean)foundJava);
        Assert.assertTrue((boolean)foundCompressedLibrary);
        Assert.assertTrue((boolean)foundJavaLibrary);
    }
}

