/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.RefreshTestContentProvider;
import org.eclipse.jface.tests.performance.TableViewerRefreshTest;
import org.eclipse.jface.tests.performance.TestElement;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.tests.performance.TestRunnable;

public class FastTableViewerRefreshTest
extends TableViewerRefreshTest {
    public FastTableViewerRefreshTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public FastTableViewerRefreshTest(String testName) {
        super(testName);
    }

    public void testRefreshMultiple() throws Throwable {
        this.openBrowser();
        FastTableViewerRefreshTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                FastTableViewerRefreshTest.this.startMeasuring();
                int i = 0;
                while (i < 10) {
                    FastTableViewerRefreshTest.this.viewer.refresh();
                    FastTableViewerRefreshTest.processEvents();
                    ++i;
                }
                FastTableViewerRefreshTest.this.stopMeasuring();
            }
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testUpdateMultiple() throws Throwable {
        this.openBrowser();
        FastTableViewerRefreshTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                FastTableViewerRefreshTest.this.startMeasuring();
                int i = 0;
                while (i < 10) {
                    TableItem[] items = FastTableViewerRefreshTest.this.viewer.getTable().getItems();
                    int j = 0;
                    while (j < items.length) {
                        TableItem item = items[j];
                        TestElement element = RefreshTestContentProvider.allElements[j];
                        FastTableViewerRefreshTest.this.viewer.testUpdateItem((Widget)item, element);
                        ++j;
                    }
                    FastTableViewerRefreshTest.processEvents();
                    ++i;
                }
                FastTableViewerRefreshTest.this.stopMeasuring();
            }
        }, MIN_ITERATIONS, this.slowGTKIterations(), JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }
}

