/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;

public class ListPopulationTest
extends BasicPerformanceTest {
    List list;

    public ListPopulationTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public ListPopulationTest(String testName) {
        super(testName);
    }

    protected void openBrowser() {
        Display fDisplay = Display.getCurrent();
        if (fDisplay == null) {
            fDisplay = new Display();
        }
        Shell shell = new Shell(fDisplay);
        shell.setSize(500, 500);
        shell.setLayout((Layout)new FillLayout());
        this.list = new List((Composite)shell, 0);
        shell.open();
    }

    public void testSmallAdd() throws Throwable {
        this.addBench(100);
    }

    public void testSmallSetItems() throws Throwable {
        this.setItemsBench(100);
    }

    public void testMediumAdd() throws Throwable {
        this.addBench(5000);
    }

    public void testMediumSetItems() throws Throwable {
        this.setItemsBench(5000);
    }

    public void testLargeAdd() throws Throwable {
        this.addBench(50000);
    }

    public void testLargeSetItems() throws Throwable {
        this.setItemsBench(50000);
    }

    public void addBench(int count) throws Throwable {
        this.openBrowser();
        final String[] items = this.getItems(count);
        ListPopulationTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                ListPopulationTest.this.list.removeAll();
                ListPopulationTest.this.startMeasuring();
                int j = 0;
                while (j < items.length) {
                    ListPopulationTest.this.list.add(items[j]);
                    ++j;
                }
                ListPopulationTest.processEvents();
                ListPopulationTest.this.stopMeasuring();
            }
        });
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void setItemsBench(int count) throws Throwable {
        this.openBrowser();
        final String[] items = this.getItems(count);
        ListPopulationTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                ListPopulationTest.this.list.removeAll();
                ListPopulationTest.this.startMeasuring();
                ListPopulationTest.this.list.setItems(items);
                ListPopulationTest.processEvents();
                ListPopulationTest.this.stopMeasuring();
            }
        });
        this.commitMeasurements();
        this.assertPerformance();
    }

    private String[] getItems(int count) {
        String[] items = new String[count];
        int j = 0;
        while (j < items.length) {
            items[j] = "Element " + String.valueOf(j);
            ++j;
        }
        return items;
    }
}

