/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;

public class ProgressMonitorDialogPerformanceTest
extends BasicPerformanceTest {
    public ProgressMonitorDialogPerformanceTest(String testName) {
        super(testName);
    }

    public ProgressMonitorDialogPerformanceTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public void testLongNames() throws Throwable {
        this.tagIfNecessary("JFace - 10000 element task name in progress dialog", Dimension.ELAPSED_PROCESS);
        this.setDegradationComment("The test changed in 3.7. For details, consult bug 298952.");
        Display display = Display.getCurrent();
        if (display == null) {
            display = new Display();
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(new Shell(display));
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                char[] chars = new char[10000];
                int i = 0;
                while (i < chars.length) {
                    chars[i] = 65;
                    ++i;
                }
                String taskName = new String(chars);
                monitor.setTaskName(taskName);
                ProgressMonitorDialogPerformanceTest.processEvents();
                int testCounter = 0;
                while (testCounter < 20) {
                    ProgressMonitorDialogPerformanceTest.this.startMeasuring();
                    int counter = 0;
                    while (counter < 30) {
                        monitor.setTaskName(taskName);
                        ProgressMonitorDialogPerformanceTest.processEvents();
                        ++counter;
                    }
                    ProgressMonitorDialogPerformanceTest.processEvents();
                    ProgressMonitorDialogPerformanceTest.this.stopMeasuring();
                    ++testCounter;
                }
            }
        };
        try {
            dialog.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            ProgressMonitorDialogPerformanceTest.fail((String)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            ProgressMonitorDialogPerformanceTest.fail((String)e.getMessage(), (Throwable)e);
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

