/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.tests.performance.TestElement;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class RefreshTestContentProvider
implements IStructuredContentProvider {
    static int seed = 1;
    static TestElement[] allElements;
    public static int ELEMENT_COUNT;
    TestElement[] currentElements;

    static {
        ELEMENT_COUNT = 10000;
        allElements = new TestElement[ELEMENT_COUNT];
        int i = 0;
        while (i < ELEMENT_COUNT) {
            RefreshTestContentProvider.allElements[i] = new TestElement(i);
            ++i;
        }
    }

    void preSortElements(Viewer viewer, ViewerSorter sorter) {
        sorter.sort(viewer, (Object[])this.currentElements);
    }

    public RefreshTestContentProvider(int size) {
        Assert.isTrue((size <= ELEMENT_COUNT ? 1 : 0) != 0);
        this.setSize(size);
    }

    public void setSize(int size) {
        this.currentElements = new TestElement[size];
        int i = 0;
        while (i < this.currentElements.length) {
            this.currentElements[i] = allElements[i];
            ++i;
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.currentElements;
    }

    public void dispose() {
        this.currentElements = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void refreshElements() {
        int i = 0;
        while (i < ELEMENT_COUNT) {
            this.currentElements[i] = new TestElement(i + seed);
            ++i;
        }
        seed += 257;
    }

    public void cloneElements() {
        this.currentElements = (TestElement[])this.currentElements.clone();
    }
}

