/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.performance;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.tests.performance.JFacePerformanceSuite;
import org.eclipse.jface.tests.performance.TestTreeElement;
import org.eclipse.jface.tests.performance.TreeTest;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.tests.performance.TestRunnable;

public class TreeAddTest
extends TreeTest {
    static int TEST_COUNT = 1000;

    public TreeAddTest(String testName, int tagging) {
        super(testName, tagging);
    }

    public TreeAddTest(String testName) {
        super(testName);
    }

    public void testAddOneAtATime() {
        this.openBrowser();
        int i = 0;
        while (i < ITERATIONS / 10) {
            TestTreeElement input = new TestTreeElement(0, null);
            this.viewer.setInput((Object)input);
            input.createChildren(TEST_COUNT);
            TreeAddTest.processEvents();
            this.startMeasuring();
            int j = 0;
            while (j < input.children.length) {
                this.viewer.add((Object)input, (Object)input.children[j]);
                TreeAddTest.processEvents();
                ++j;
            }
            this.stopMeasuring();
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testAddTen() throws CoreException {
        this.doTestAdd(10, TEST_COUNT, false);
    }

    public void testAddFifty() throws CoreException {
        this.doTestAdd(50, TEST_COUNT, false);
    }

    public void testAddHundred() throws CoreException {
        this.tagIfNecessary("JFace - Add 1000 items in 10 blocks to TreeViewer", Dimension.ELAPSED_PROCESS);
        this.doTestAdd(100, TEST_COUNT, false);
    }

    protected void doTestAdd(final int increment, final int total, final boolean preSort) throws CoreException {
        this.openBrowser();
        TreeAddTest.exercise(new TestRunnable(){

            @Override
            public void run() {
                TestTreeElement input = new TestTreeElement(0, null);
                TreeAddTest.this.viewer.setInput((Object)input);
                input.createChildren(total);
                if (preSort) {
                    TreeAddTest.this.viewer.getSorter().sort((Viewer)TreeAddTest.this.viewer, (Object[])input.children);
                }
                ArrayList<Object[]> batches = new ArrayList<Object[]>();
                int blocks = input.children.length / increment;
                int j = 0;
                while (j < blocks) {
                    Object[] batch = new Object[increment];
                    System.arraycopy(input.children, j * increment, batch, 0, increment);
                    batches.add(batch);
                    j += increment;
                }
                TreeAddTest.processEvents();
                Object[] batchArray = batches.toArray();
                TreeAddTest.this.startMeasuring();
                int k = 0;
                while (k < batchArray.length) {
                    TreeAddTest.this.viewer.add((Object)input, (Object[])batchArray[k]);
                    TreeAddTest.processEvents();
                    ++k;
                }
                TreeAddTest.this.stopMeasuring();
            }
        }, MIN_ITERATIONS, ITERATIONS, JFacePerformanceSuite.MAX_TIME);
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void testAddThousand() throws CoreException {
        this.doTestAdd(1000, 2000, false);
    }

    public void testAddTwoThousand() throws CoreException {
        this.doTestAdd(2000, 4000, false);
    }

    public void testAddHundredPreSort() throws CoreException {
        this.doTestAdd(100, 1000, true);
    }

    public void testAddThousandPreSort() throws CoreException {
        this.tagIfNecessary("JFace - Add 2000 items in 2 blocks to TreeViewer", Dimension.ELAPSED_PROCESS);
        this.doTestAdd(1000, 2000, true);
    }
}

