/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.text.DecimalFormat;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.harness.util.UITestCase;
import org.eclipse.ui.tests.performance.PerformanceTester;
import org.eclipse.ui.tests.performance.TestRunnable;
import org.eclipse.ui.tests.performance.UIPerformancePlugin;
import org.osgi.framework.BundleContext;

public abstract class BasicPerformanceTest
extends UITestCase {
    public static final String INTERACTIVE = "org.eclipse.ui.tests.performance.interactive";
    public static final int NONE = 0;
    public static final int LOCAL = 1;
    public static final int GLOBAL = 2;
    private PerformanceTester tester;
    private IProject testProject;
    private final boolean tagAsGlobalSummary;
    private final boolean tagAsSummary;
    private static long startMeasuringTime;
    private static long stopMeasuringTime;
    private static boolean interactive;

    public BasicPerformanceTest(String testName) {
        this(testName, 0);
        BundleContext context = UIPerformancePlugin.getDefault().getContext();
        if (context == null) {
            System.err.println("Unable to retrieve bundle context from BasicPerformanceTest; interactive mode is disabled");
            return;
        }
        String filterString = context.getProperty(INTERACTIVE);
        if (filterString != null && filterString.toLowerCase().equals("true")) {
            interactive = true;
        }
    }

    public BasicPerformanceTest(String testName, int tagging) {
        super(testName);
        this.tagAsGlobalSummary = (tagging & 2) != 0;
        this.tagAsSummary = (tagging & 1) != 0;
    }

    private boolean shouldGloballyTag() {
        return this.tagAsGlobalSummary;
    }

    private boolean shouldLocallyTag() {
        return this.tagAsSummary;
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        if (interactive) {
            return;
        }
        this.tester = new PerformanceTester((TestCase)this);
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        if (interactive) {
            return;
        }
        this.tester.dispose();
    }

    protected IProject getProject() {
        if (this.testProject == null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.testProject = workspace.getRoot().getProject("Performance Project");
        }
        return this.testProject;
    }

    public void assertPerformance() {
        if (interactive) {
            return;
        }
        this.tester.assertPerformance();
    }

    public void assertPerformanceInRelativeBand(Dimension dim, int lowerPercentage, int upperPercentage) {
        if (interactive) {
            return;
        }
        this.tester.assertPerformanceInRelativeBand(dim, lowerPercentage, upperPercentage);
    }

    public void commitMeasurements() {
        if (interactive) {
            return;
        }
        this.tester.commitMeasurements();
    }

    public void startMeasuring() {
        if (interactive) {
            startMeasuringTime = System.currentTimeMillis();
            return;
        }
        this.tester.startMeasuring();
    }

    public void stopMeasuring() {
        if (interactive) {
            stopMeasuringTime = System.currentTimeMillis();
            return;
        }
        this.tester.stopMeasuring();
    }

    private void tagAsGlobalSummary(String shortName, Dimension dimension) {
        System.out.println("GLOBAL " + shortName);
        if (interactive) {
            return;
        }
        this.tester.tagAsGlobalSummary(shortName, dimension);
    }

    private void tagAsSummary(String shortName, Dimension dimension) {
        System.out.println("LOCAL " + shortName);
        if (interactive) {
            return;
        }
        this.tester.tagAsSummary(shortName, dimension);
    }

    public void tagIfNecessary(String shortName, Dimension dimension) {
        if (this.shouldGloballyTag()) {
            this.tagAsGlobalSummary(shortName, dimension);
        }
        if (this.shouldLocallyTag()) {
            this.tagAsSummary(shortName, dimension);
        }
    }

    public static void waitForBackgroundJobs() {
        Job backgroundJob = new Job("This is a test job which sits around being low priority until everything else finishes"){

            protected IStatus run(IProgressMonitor monitor) {
                return Status.OK_STATUS;
            }
        };
        backgroundJob.setPriority(50);
        boolean hadEvents = true;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            while (hadEvents) {
                hadEvents = false;
                backgroundJob.schedule(0L);
                try {
                    backgroundJob.join();
                }
                catch (InterruptedException interruptedException) {}
                while (display.readAndDispatch()) {
                    hadEvents = true;
                }
            }
        }
    }

    public static void exercise(TestRunnable runnable) throws CoreException {
        BasicPerformanceTest.exercise(runnable, 3, 100, 4000);
    }

    public static void exercise(TestRunnable runnable, int minIterations, int maxIterations, int maxTime) throws CoreException {
        if (interactive) {
            DecimalFormat f = new DecimalFormat("##.000");
            DecimalFormat p = new DecimalFormat("#0.0");
            try {
                runnable.run();
                int initialRuns = 3;
                long startTime = System.currentTimeMillis();
                int i = 0;
                while (i < initialRuns) {
                    runnable.run();
                    ++i;
                }
                long currentTime = System.currentTimeMillis();
                double timePerRun = (double)(currentTime - startTime) / 1000.0 / (double)initialRuns;
                int totalRuns = initialRuns;
                double interval = 10.0;
                long intervalMillis = (long)(1000.0 * interval);
                double averagePerInterval = interval / timePerRun;
                System.out.println("Time per run (roughly): " + f.format(timePerRun) + " - expecting " + f.format(averagePerInterval) + " runs per 10 seconds.");
                System.err.println("Remember - higher means faster: the following shows number of runs per interval (seconds=" + p.format(interval) + ").");
                while (true) {
                    int numOperations = 0;
                    long elapsed = 0L;
                    while (elapsed < intervalMillis) {
                        startMeasuringTime = -1L;
                        stopMeasuringTime = -1L;
                        startTime = System.currentTimeMillis();
                        ++numOperations;
                        runnable.run();
                        currentTime = System.currentTimeMillis();
                        if (startMeasuringTime != -1L && stopMeasuringTime != -1L) {
                            elapsed += stopMeasuringTime - startMeasuringTime;
                            continue;
                        }
                        elapsed += currentTime - startTime;
                    }
                    timePerRun = (double)elapsed / 1000.0 / (double)numOperations;
                    double operationsPerInterval = interval / timePerRun;
                    double deviation = (operationsPerInterval - averagePerInterval) / averagePerInterval * 100.0;
                    System.out.println(String.valueOf(f.format(operationsPerInterval)) + " runs/interval    (" + (deviation >= 0.0 ? "+" : "-") + p.format(Math.abs(deviation)) + "% relative to avg=" + f.format(averagePerInterval) + ")");
                    averagePerInterval = (averagePerInterval * (double)totalRuns + operationsPerInterval * (double)numOperations) / (double)(totalRuns + numOperations);
                    totalRuns += numOperations;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        long startTime = System.currentTimeMillis();
        int counter = 0;
        while (counter < maxIterations) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, UIPerformancePlugin.getDefault().getBundle().getSymbolicName(), 0, "An exception occurred", (Throwable)e));
            }
            long curTime = System.currentTimeMillis();
            if (curTime - startTime > (long)maxTime && counter >= minIterations - 1) break;
            ++counter;
        }
    }

    public void setDegradationComment(String string) {
        if (interactive) {
            return;
        }
        this.tester.setDegradationComment(string);
    }
}

