/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.ui.tests.performance.UIPerformancePlugin;
import org.osgi.framework.BundleContext;

public class FilteredTestSuite
extends TestSuite {
    public static final String FILTER_TEST_NAME = "org.eclipse.ui.tests.filter";
    private String filterTestClassName;
    private String filterTestName;

    public FilteredTestSuite() {
        int methodSeparator;
        BundleContext context = UIPerformancePlugin.getDefault().getContext();
        if (context == null) {
            System.err.println("UIPerformanceTestSuite was unable to retirieve bundle context; test filtering is disabled");
            return;
        }
        String filterString = context.getProperty(FILTER_TEST_NAME);
        if (filterString == null) {
            return;
        }
        if (filterString.endsWith("()")) {
            filterString = filterString.substring(0, filterString.length() - 2);
        }
        if ((methodSeparator = filterString.indexOf(35)) != -1) {
            this.filterTestClassName = methodSeparator == 0 ? null : filterString.substring(0, methodSeparator);
            this.filterTestName = methodSeparator + 1 < filterString.length() ? filterString.substring(methodSeparator + 1) : null;
        } else {
            this.filterTestClassName = filterString;
            this.filterTestName = null;
        }
    }

    public void addTest(Test test) {
        if (this.filterTestClassName != null || this.filterTestName != null) {
            if (test instanceof TestSuite) {
                this.addFilteredTestSuite((TestSuite)test);
                return;
            }
            if (test instanceof TestCase) {
                this.addFilteredTestCase((TestCase)test);
                return;
            }
        }
        super.addTest(test);
    }

    private void addFilteredTestSuite(TestSuite testSuite) {
        Enumeration allTests = testSuite.tests();
        while (allTests.hasMoreElements()) {
            Object subTest = allTests.nextElement();
            if (subTest instanceof TestSuite) {
                this.addFilteredTestSuite((TestSuite)subTest);
                continue;
            }
            if (!(subTest instanceof TestCase)) continue;
            if (this.filterTestClassName != null) {
                Class<?> testClass = subTest.getClass();
                String subTestQualName = testClass.getName();
                if (subTestQualName == null) {
                    subTestQualName = "";
                }
                int index = subTestQualName.lastIndexOf(46);
                String subTestName = "";
                if (index != -1 && index + 1 < subTestQualName.length()) {
                    subTestName = subTestQualName.substring(index + 1);
                }
                if (!subTestName.matches(this.filterTestClassName) && !subTestQualName.matches(this.filterTestClassName)) continue;
            }
            this.addFilteredTestCase((TestCase)subTest);
        }
    }

    private void addFilteredTestCase(TestCase testCase) {
        if (this.filterTestName == null) {
            super.addTest((Test)testCase);
            return;
        }
        String testCaseName = testCase.getName();
        if (testCaseName == null) {
            return;
        }
        if (testCaseName.matches(this.filterTestName)) {
            super.addTest((Test)testCase);
        }
    }
}

