/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.tests.harness.util.UITestCase;
import org.eclipse.ui.tests.performance.ObjectContributionClasses;

public final class ObjectContributionTest
extends UITestCase {
    public ObjectContributionTest(String name) {
        super(name);
    }

    public final void testObjectStateContentType() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject("ObjectContributionTestProject");
        testProject.create(null);
        testProject.open(null);
        IFile xmlFile = testProject.getFile("ObjectContributionTest.xml");
        ByteArrayInputStream inputStream = new ByteArrayInputStream("<testObjectStateContentTypeElement></testObjectStateContentTypeElement>".getBytes());
        xmlFile.create((InputStream)inputStream, true, null);
        StructuredSelection selection = new StructuredSelection((Object)xmlFile);
        this.assertPopupMenus("1", new String[]{"org.eclipse.ui.tests.testObjectStateContentType"}, (ISelection)selection, null, true);
    }

    public final void testContributorResourceAdapter() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject("testContributorResourceAdapter");
        if (!testProject.exists()) {
            testProject.create(null);
        }
        if (!testProject.isOpen()) {
            testProject.open(null);
        }
        this.assertPopupMenus("1", new String[]{"IResource.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.CResource()}), IResource.class, true);
        this.assertPopupMenus("2", new String[]{"IProject.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.CFile()}), null, false);
        this.assertPopupMenus("3", new String[]{"IFile.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.CFile()}), IFile.class, true);
        this.assertPopupMenus("4", new String[]{"IResource.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.CFile(), new ObjectContributionClasses.CResource()}), IResource.class, true);
        this.assertPopupMenus("5", new String[]{"IFile.1", "IProject.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.CFile(), new ObjectContributionClasses.CResource()}), IResource.class, false);
        this.assertPopupMenus("6", new String[]{"ResourceMapping.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.CFile(), new ObjectContributionClasses.CResource()}), ResourceMapping.class, true);
        this.assertPopupMenus("7", new String[]{"ResourceMapping.1", "IResource.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.ModelElement()}), ResourceMapping.class, true);
        this.assertPopupMenus("8", new String[]{"ResourceMapping.1", "IResource.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.CResourceOnly()}), ResourceMapping.class, true);
    }

    public final void testAdaptables() {
        this.assertPopupMenus("1", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.A()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("2", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.A(), new ObjectContributionClasses.B()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("3", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.A(), new ObjectContributionClasses.B(), new ObjectContributionClasses.C(), new ObjectContributionClasses.Common()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("4", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.Common(), new ObjectContributionClasses.C(), new ObjectContributionClasses.B(), new ObjectContributionClasses.A()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("5", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.Common(), new ObjectContributionClasses.C(), new ObjectContributionClasses.B(), new ObjectContributionClasses.C(), new ObjectContributionClasses.A(), new ObjectContributionClasses.Common()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("6", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.C(), new ObjectContributionClasses.Common()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("7", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new Object()}), ObjectContributionClasses.ICommon.class, false);
        this.assertPopupMenus("8", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.C(), new Object()}), ObjectContributionClasses.ICommon.class, false);
        this.assertPopupMenus("9", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.C(), new ObjectContributionClasses.A(), new Object()}), ObjectContributionClasses.ICommon.class, false);
    }

    public final void testDuplicateAdaptables() {
        this.assertPopupMenus("1", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.D()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("1", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.D()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("2", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.D(), new ObjectContributionClasses.A()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("3", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.A(), new ObjectContributionClasses.D()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("4", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.Common(), new ObjectContributionClasses.D()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("5", new String[]{"ICommon.1"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.D(), new ObjectContributionClasses.Common()}), ObjectContributionClasses.ICommon.class, true);
    }

    public final void testNonAdaptableContributions() {
        this.assertPopupMenus("1", new String[]{"ICommon.2"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.A(), new ObjectContributionClasses.B()}), ObjectContributionClasses.ICommon.class, false);
        this.assertPopupMenus("2", new String[]{"ICommon.2"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.D(), new ObjectContributionClasses.C(), new ObjectContributionClasses.Common()}), ObjectContributionClasses.ICommon.class, true);
        this.assertPopupMenus("3", new String[]{"Common.2"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.D(), new ObjectContributionClasses.C(), new ObjectContributionClasses.A()}), ObjectContributionClasses.ICommon.class, false);
        this.assertPopupMenus("4", new String[]{"Common.2"}, (ISelection)new StructuredSelection(new Object[]{new ObjectContributionClasses.B(), new ObjectContributionClasses.C(), new ObjectContributionClasses.A()}), ObjectContributionClasses.ICommon.class, false);
    }

    public void assertPopupMenus(String name, String[] commandIds, final ISelection selection, Class<?> selectionType, boolean existance) {
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection2) {
            }
        };
        WorkbenchWindow window = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IWorkbenchPart part = page.getActivePartReference().getPart(true);
        MenuManager fakeMenuManager = new MenuManager();
        fakeMenuManager.add((IContributionItem)new GroupMarker("additions"));
        PopupMenuExtender extender = new PopupMenuExtender(null, fakeMenuManager, selectionProvider, part, ((PartSite)part.getSite()).getContext());
        extender.menuAboutToShow((IMenuManager)fakeMenuManager);
        extender.dispose();
        IContributionItem[] items = fakeMenuManager.getItems();
        HashSet<String> seenCommands = new HashSet<String>(Arrays.asList(commandIds));
        ArrayList<String> commands = new ArrayList<String>(Arrays.asList(commandIds));
        int i = 0;
        while (i < items.length) {
            IContributionItem item;
            IContributionItem contributionItem = items[i];
            if (selectionType != null && (item = contributionItem) instanceof SubContributionItem) {
                item = ((SubContributionItem)contributionItem).getInnerItem();
            }
            String id = contributionItem.getId();
            if (existance) {
                boolean removed = commands.remove(id);
                if (seenCommands.contains(id) && !removed) {
                    ObjectContributionTest.fail((String)(String.valueOf(name) + " item duplicated in the context menu: " + id));
                }
            } else {
                ObjectContributionTest.assertTrue((String)(String.valueOf(name) + " item should not be in the context menu"), (!commands.contains(id) ? 1 : 0) != 0);
            }
            ++i;
        }
        if (existance && !commands.isEmpty()) {
            ObjectContributionTest.fail((String)(String.valueOf(name) + " Missing " + ((Object)commands).toString() + " from context menu."));
        }
    }
}

