/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.ArrayList;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.ObjectContributionClasses;
import org.eclipse.ui.tests.performance.ObjectContributionTest;

public class ObjectContributionsPerformance
extends BasicPerformanceTest {
    public static final int SEED = 1001001;
    private IStructuredSelection selection;

    public static Test suite() {
        TestSuite suite = new TestSuite("Object contribution performance");
        suite.addTest((Test)new ObjectContributionsPerformance("large selection, limited contributors", ObjectContributionsPerformance.generateAdaptableSelection(1001001, 5000), 0));
        suite.addTest((Test)new ObjectContributionsPerformance("limited selection, limited contributors", ObjectContributionsPerformance.generateAdaptableSelection(1001001, 50), 0));
        return suite;
    }

    public ObjectContributionsPerformance(String label, IStructuredSelection selection, int tagging) {
        super("testObjectContributions:" + label, tagging);
        this.selection = selection;
    }

    protected void runTest() {
        ObjectContributionTest tests = new ObjectContributionTest("testObjectContributions");
        this.tagIfNecessary("UI - " + this.selection.size() + " contribution(s)", Dimension.ELAPSED_PROCESS);
        this.startMeasuring();
        int i = 0;
        while (i < 5000) {
            tests.assertPopupMenus("1", new String[]{"bogus"}, (ISelection)this.selection, null, false);
            ++i;
        }
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    protected static IStructuredSelection generateAdaptableSelection(int seed, int size) {
        Random rand = new Random(seed);
        ArrayList<Object> selection = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            switch ((int)Math.round(rand.nextDouble() * 5.0)) {
                case 0: {
                    selection.add(new ObjectContributionClasses.A());
                    break;
                }
                case 1: {
                    selection.add(new ObjectContributionClasses.B());
                    break;
                }
                case 2: {
                    selection.add(new ObjectContributionClasses.C());
                    break;
                }
                case 3: {
                    selection.add(new ObjectContributionClasses.Common());
                    break;
                }
                case 4: {
                    selection.add(new ObjectContributionClasses.D());
                    break;
                }
                case 5: {
                    selection.add(new ObjectContributionClasses.A1());
                    break;
                }
                default: {
                    selection.add(new Object());
                }
            }
            ++i;
        }
        return new StructuredSelection(selection);
    }
}

