/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.osgi.framework.Bundle;

public class OpenNavigatorFolderTest
extends PerformanceTestCase {
    public void testOpenNavigatorFolder() {
        block46: {
            IProject project = this.createProject("testViewAndContentTypeProject");
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.tests.performance");
            URL url = bundle.getEntry("data/testContentType.zip");
            ZipInputStream zis = null;
            try {
                try {
                    zis = new ZipInputStream(url.openStream());
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        block44: {
                            ByteArrayOutputStream baos;
                            block42: {
                                baos = new ByteArrayOutputStream();
                                try {
                                    try {
                                        byte[] b = new byte[2048];
                                        int read = zis.read(b);
                                        while (read != -1) {
                                            baos.write(b, 0, read);
                                            read = zis.read(b);
                                        }
                                    }
                                    catch (IOException e) {
                                        Assert.fail((String)e.getMessage());
                                        try {
                                            baos.close();
                                        }
                                        catch (IOException e2) {
                                            Assert.fail((String)e2.getMessage());
                                        }
                                        break block42;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        baos.close();
                                    }
                                    catch (IOException e) {
                                        Assert.fail((String)e.getMessage());
                                    }
                                    throw throwable;
                                }
                                try {
                                    baos.close();
                                }
                                catch (IOException e) {
                                    Assert.fail((String)e.getMessage());
                                }
                            }
                            IFile file = project.getFile(entry.getName());
                            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                            try {
                                try {
                                    if (!file.exists()) {
                                        file.create((InputStream)bais, true, (IProgressMonitor)new NullProgressMonitor());
                                    } else {
                                        file.setContents((InputStream)bais, true, false, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                }
                                catch (CoreException e) {
                                    Assert.fail((String)e.getMessage());
                                    try {
                                        bais.close();
                                    }
                                    catch (IOException e3) {
                                        Assert.fail((String)e3.getMessage());
                                    }
                                    break block44;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    bais.close();
                                }
                                catch (IOException e) {
                                    Assert.fail((String)e.getMessage());
                                }
                                throw throwable;
                            }
                            try {
                                bais.close();
                            }
                            catch (IOException e) {
                                Assert.fail((String)e.getMessage());
                            }
                        }
                        entry = zis.getNextEntry();
                    }
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    try {
                        if (zis != null) {
                            zis.close();
                        }
                        break block46;
                    }
                    catch (IOException e4) {
                        Assert.fail((String)e4.getMessage());
                    }
                    break block46;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                }
                throw throwable;
            }
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        this.startMeasuring();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart view = null;
        try {
            view = activePage.showView("org.eclipse.ui.views.ResourceNavigator");
        }
        catch (PartInitException e) {
            Assert.fail((String)e.getMessage());
        }
        ResourceNavigator navigatorView = null;
        try {
            navigatorView = (ResourceNavigator)view;
        }
        catch (ClassCastException e) {
            Assert.fail((String)e.getMessage());
        }
        navigatorView.getTreeViewer().expandAll();
        this.stopMeasuring();
        this.commitMeasurements();
        this.assertPerformance();
    }

    private IProject createProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            try {
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        return project;
    }
}

