/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.parts.PerformanceProblemsView;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ProblemsViewPerformanceTest
extends BasicPerformanceTest {
    private String EMPTY_PERSPECTIVE_ID = "org.eclipse.ui.tests.harness.util.EmptyPerspective";
    private String PROBLEMS_VIEW_ID = "org.eclipse.ui.tests.performance.problemsView";

    public ProblemsViewPerformanceTest(String testName) {
        super(testName);
    }

    public void testPopulation() {
        PerformanceProblemsView view;
        IWorkbenchWindow window = this.openTestWindow(this.EMPTY_PERSPECTIVE_ID);
        IWorkbenchPage page = window.getActivePage();
        try {
            view = (PerformanceProblemsView)page.showView(this.PROBLEMS_VIEW_ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            ProblemsViewPerformanceTest.fail();
            return;
        }
        this.tagIfNecessary("UI - Problems View population", Dimension.ELAPSED_PROCESS);
        int i = 0;
        while (i < 100) {
            this.createMarkers();
            ProblemsViewPerformanceTest.processEvents();
            this.startMeasuring();
            while (view.getTreeWidget().getItemCount() == 0) {
                ProblemsViewPerformanceTest.processEvents();
            }
            this.stopMeasuring();
            this.removeMarkers();
            while (view.getTreeWidget().getItemCount() > 0) {
                ProblemsViewPerformanceTest.processEvents();
            }
            ++i;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }

    private void removeMarkers() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IMarker[] markers = root.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            int i = 0;
            while (i < markers.length) {
                String message = (String)markers[i].getAttribute("message");
                if (message != null && message.startsWith("this is a test")) {
                    markers[i].delete();
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createMarkers() {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            HashMap<String, Object> attribs = new HashMap<String, Object>();
            int i = 0;
            while (i < 1000) {
                attribs.put("severity", 2);
                attribs.put("message", "this is a test " + i);
                MarkerUtilities.createMarker((IResource)root, attribs, (String)"org.eclipse.core.resources.problemmarker");
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

