/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.TestRunnable;

public class ProgressReportingTest
extends BasicPerformanceTest {
    public static final int ITERATIONS = 10000000;
    public static final int VERY_SLOW_OPERATION_ITERATIONS = 100000;
    public static final int MAX_RUNTIME = 4000;
    public static final int MAX_ITERATIONS = 100;
    private volatile boolean isDone;
    private Display display;
    private boolean oldRunInBackgroundSetting;

    public ProgressReportingTest(String testName) {
        super(testName);
    }

    @Override
    protected void doSetUp() throws Exception {
        this.oldRunInBackgroundSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND");
        this.display = Display.getCurrent();
        super.doSetUp();
    }

    @Override
    protected void doTearDown() throws Exception {
        boolean newRunInBackgroundSetting = this.oldRunInBackgroundSetting;
        this.setRunInBackground(newRunInBackgroundSetting);
        super.doTearDown();
    }

    private void setRunInBackground(boolean newRunInBackgroundSetting) {
        WorkbenchPlugin.getDefault().getPreferenceStore().setValue("RUN_IN_BACKGROUND", newRunInBackgroundSetting);
    }

    public void runAsyncTest(final Runnable testContent) throws Exception {
        final Display display = Display.getCurrent();
        this.tagIfNecessary(this.getName(), Dimension.ELAPSED_PROCESS);
        ProgressReportingTest.exercise(new TestRunnable(){

            @Override
            public void run() throws Exception {
                ProgressReportingTest.this.startMeasuring();
                ProgressReportingTest.this.isDone = false;
                testContent.run();
                while (!ProgressReportingTest.this.isDone) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                ProgressReportingTest.this.stopMeasuring();
            }
        }, 1, 100, 4000);
        this.commitMeasurements();
        this.assertPerformance();
    }

    public void endAsyncTest(Object ignored) {
        this.isDone = true;
        this.display.asyncExec(() -> {});
    }

    public void testJobNoMonitorUsage() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testJobSetTaskName() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                monitor.setTaskName(Integer.toString(i));
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testJobSubTask() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                monitor.subTask(Integer.toString(i));
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testJobIsCanceled() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testJobWorked() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            monitor.beginTask("Test Job", 10000000);
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                monitor.worked(1);
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testJobSubMonitorSplit() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000000);
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                subMonitor.split(1);
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testJobSubMonitorNewChild() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000000);
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                subMonitor.newChild(1);
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testJobSubMonitorWorked() throws Exception {
        this.openTestWindow();
        this.setRunInBackground(true);
        this.runAsyncTest(() -> Job.create((String)"Test Job", monitor -> {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10000000);
            int i = 0;
            long result = 0L;
            while (i < 10000000) {
                subMonitor.worked(1);
                result += (long)i;
                ++i;
            }
            this.endAsyncTest(result);
        }).schedule());
    }

    public void testRunInForegroundNoMonitorUsage() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                long result = 0L;
                while (i < 100000) {
                    result += (long)i;
                    ++i;
                }
                this.endAsyncTest(result);
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    public void testRunInForegroundWorked() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                long result = 0L;
                while (i < 100000) {
                    monitor.worked(1);
                    result += (long)i;
                    ++i;
                }
                this.endAsyncTest(result);
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    public void testRunInForegroundSetTaskName() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                long result = 0L;
                while (i < 100000) {
                    monitor.setTaskName(Integer.toString(i));
                    result += (long)i;
                    ++i;
                }
                this.endAsyncTest(result);
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    public void testRunInForegroundSubTask() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                long result = 0L;
                while (i < 100000) {
                    monitor.subTask(Integer.toString(i));
                    result += (long)i;
                    ++i;
                }
                this.endAsyncTest(result);
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    public void testRunInForegroundIsCanceled() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.setRunInBackground(false);
        this.runAsyncTest(() -> {
            Job j = Job.create((String)"Test Job", monitor -> {
                monitor.beginTask("Test Job", 100000);
                int i = 0;
                long result = 0L;
                while (i < 100000) {
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    result += (long)i;
                    ++i;
                }
                this.endAsyncTest(result);
            });
            j.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(window.getShell(), j);
        });
    }

    public void testProgressMonitorDialogNoMonitorUsage() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Test Job", 10000000);
                        int i = 0;
                        long result = 0L;
                        while (i < 10000000) {
                            result += (long)i;
                            ++i;
                        }
                        ProgressReportingTest.this.endAsyncTest(result);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void testProgressMonitorDialogWorked() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Test Job", 10000000);
                        int i = 0;
                        long result = 0L;
                        while (i < 10000000) {
                            monitor.worked(1);
                            result += (long)i;
                            ++i;
                        }
                        ProgressReportingTest.this.endAsyncTest(result);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void testProgressMonitorDialogIsCanceled() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Test Job", 10000000);
                        int i = 0;
                        long result = 0L;
                        while (i < 10000000) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            result += (long)i;
                            ++i;
                        }
                        ProgressReportingTest.this.endAsyncTest(result);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void testProgressMonitorDialogSetTaskName() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Test Job", 10000000);
                        int i = 0;
                        long result = 0L;
                        while (i < 10000000) {
                            monitor.setTaskName(Integer.toString(i));
                            result += (long)i;
                            ++i;
                        }
                        ProgressReportingTest.this.endAsyncTest(result);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void testProgressMonitorDialogSubTask() throws Exception {
        IWorkbenchWindow window = this.openTestWindow();
        this.runAsyncTest(() -> {
            try {
                new ProgressMonitorDialog(window.getShell()).run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Test Job", 10000000);
                        int i = 0;
                        long result = 0L;
                        while (i < 10000000) {
                            monitor.subTask(Integer.toString(i));
                            result += (long)i;
                            ++i;
                        }
                        ProgressReportingTest.this.endAsyncTest(result);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

