/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.performance.ObjectContributionsPerformance;
import org.eclipse.ui.tests.performance.OpenClosePerspectiveTest;
import org.eclipse.ui.tests.performance.OpenCloseWindowTest;
import org.eclipse.ui.tests.performance.PerspectiveSwitchTest;
import org.eclipse.ui.tests.performance.layout.PerspectiveWidgetFactory;
import org.eclipse.ui.tests.performance.layout.ResizeTest;

class WorkbenchPerformanceSuite
extends TestSuite {
    private static String RESOURCE_PERSPID = "org.eclipse.ui.resourcePerspective";
    public static final String[] PERSPECTIVE_IDS = new String[]{"org.eclipse.ui.tests.harness.util.EmptyPerspective2", "org.eclipse.ui.tests.performancePerspective1", RESOURCE_PERSPID, "org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.debug.ui.DebugPerspective"};
    public static String resizeFingerprintTest = RESOURCE_PERSPID;
    public static final String[][] PERSPECTIVE_SWITCH_PAIRS = new String[][]{{"org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.debug.ui.DebugPerspective", "1.java"}, {"org.eclipse.ui.tests.performancePerspective1", "org.eclipse.ui.tests.performancePerspective2", "1.perf_basic"}, {"org.eclipse.ui.tests.dnd.dragdrop", "org.eclipse.ui.tests.fastview_perspective", "1.perf_basic"}, {"org.eclipse.jdt.ui.JavaPerspective", "org.eclipse.ui.tests.util.EmptyPerspective", "1.perf_basic"}, {RESOURCE_PERSPID, "org.eclipse.jdt.ui.JavaPerspective", "1.java"}};
    public static final String[] VIEW_IDS = new String[]{"org.eclipse.ui.views.ProblemView", "org.eclipse.ui.views.ResourceNavigator"};
    public static final int ITERATIONS = 25;

    public static Test suite() {
        return new WorkbenchPerformanceSuite();
    }

    public WorkbenchPerformanceSuite() {
        this.addLayoutScenarios();
        this.addResizeScenarios();
        this.addPerspectiveSwitchScenarios();
        this.addPerspectiveOpenCloseScenarios();
        this.addWindowOpenCloseScenarios();
        this.addContributionScenarios();
    }

    private void addContributionScenarios() {
        this.addTest((Test)new ObjectContributionsPerformance("large selection, limited contributors", ObjectContributionsPerformance.generateAdaptableSelection(1001001, 5000), 0));
        this.addTest((Test)new ObjectContributionsPerformance("limited selection, limited contributors", ObjectContributionsPerformance.generateAdaptableSelection(1001001, 50), 0));
    }

    private void addWindowOpenCloseScenarios() {
        int i = 0;
        while (i < PERSPECTIVE_IDS.length) {
            this.addTest((Test)new OpenCloseWindowTest(PERSPECTIVE_IDS[i], 0));
            ++i;
        }
    }

    private void addPerspectiveOpenCloseScenarios() {
        int i = 0;
        while (i < PERSPECTIVE_IDS.length) {
            this.addTest((Test)new OpenClosePerspectiveTest(PERSPECTIVE_IDS[i], i == 1 ? 1 : 0));
            ++i;
        }
    }

    private void addPerspectiveSwitchScenarios() {
        int i = 0;
        while (i < PERSPECTIVE_SWITCH_PAIRS.length) {
            this.addTest((Test)new PerspectiveSwitchTest(PERSPECTIVE_SWITCH_PAIRS[i], 0));
            ++i;
        }
    }

    private void addLayoutScenarios() {
    }

    public static String[] getAllPerspectiveIds() {
        ArrayList<String> result = new ArrayList<String>();
        IPerspectiveDescriptor[] perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int i = 0;
        while (i < perspectives.length) {
            IPerspectiveDescriptor descriptor = perspectives[i];
            String id = descriptor.getId();
            result.add(id);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private void addResizeScenarios() {
        String[] perspectiveIds = WorkbenchPerformanceSuite.getAllPerspectiveIds();
        int i = 0;
        while (i < perspectiveIds.length) {
            String id = perspectiveIds[i];
            this.addTest((Test)new ResizeTest(new PerspectiveWidgetFactory(id), id.equals(resizeFingerprintTest) ? 1 : 0, "UI - Workbench Window Resize"));
            ++i;
        }
    }
}

