/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.performance.layout;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.test.performance.Dimension;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.tests.performance.BasicPerformanceTest;
import org.eclipse.ui.tests.performance.layout.TestWidgetFactory;

public class ResizeTest
extends BasicPerformanceTest {
    private TestWidgetFactory widgetFactory;
    private int xIterations = 5;
    private int yIterations = 5;
    private String tagString;

    public ResizeTest(TestWidgetFactory factory) {
        this(factory, 0, String.valueOf(factory.getName()) + " setSize");
    }

    public ResizeTest(TestWidgetFactory factory, int tagging, String tag) {
        super(String.valueOf(factory.getName()) + " setSize", tagging);
        this.tagString = tag;
        this.widgetFactory = factory;
    }

    protected void runTest() throws CoreException, WorkbenchException {
        this.tagIfNecessary(this.tagString, Dimension.ELAPSED_PROCESS);
        this.widgetFactory.init();
        Composite widget = this.widgetFactory.getControl();
        Rectangle initialBounds = widget.getBounds();
        Point maxSize = this.widgetFactory.getMaxSize();
        ResizeTest.waitForBackgroundJobs();
        ResizeTest.processEvents();
        int j = 0;
        while (j < 50) {
            this.startMeasuring();
            int i = 0;
            while (i < 2) {
                int xIteration = 0;
                while (xIteration < this.xIterations) {
                    int yIteration = 0;
                    while (yIteration < this.yIterations) {
                        int xSize = maxSize.x * ((xIteration + yIteration) % this.xIterations) / this.xIterations;
                        int ySize = maxSize.y * yIteration / this.yIterations;
                        widget.setSize(xSize, ySize);
                        ResizeTest.processEvents();
                        ++yIteration;
                    }
                    xIteration += 5;
                }
                ++i;
            }
            this.stopMeasuring();
            ++j;
        }
        this.commitMeasurements();
        this.assertPerformance();
        widget.setBounds(initialBounds);
        this.widgetFactory.done();
    }
}

