/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.pluginchecks;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginWalkerTest {
    private BundleContext bundleContext;
    private List<String> bundlesWithPluginXml;

    @Before
    public void setup() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Assert.assertNotNull((String)"Make sure you're running this as a plugin test", (Object)bundle);
        Assert.assertNotNull((Object)bundle);
        this.bundleContext = bundle.getBundleContext();
        this.bundlesWithPluginXml = Arrays.asList("org.eclipse.e4.ui.css.swt", "org.eclipse.e4.ui.model.workbench", "org.eclipse.e4.ui.workbench.swt", "org.eclipse.ui.forms", "org.eclipse.ui.themes", "org.eclipse.e4.ui.workbench", "org.eclipse.e4.ui.workbench.addons.swt", "org.eclipse.ui.ide", "org.eclipse.e4.ui.css.core", "org.eclipse.ui.workbench", "org.eclipse.ui.navigator.resources", "org.eclipse.ui.navigator", "org.eclipse.ui.views", "org.eclipse.ui.views.properties.tabbed", "org.eclipse.ui", "org.eclipse.ui.browser", "org.eclipse.e4.ui.css.swt.theme", "org.eclipse.ui.ide.application", "org.eclipse.ui.monitoring");
    }

    @Test
    public void validateAccessToBundle() throws Exception {
        for (String bundleSymbolicName : this.bundlesWithPluginXml) {
            Bundle bundle = PluginWalkerTest.getBundle(this.bundleContext, bundleSymbolicName);
            Assert.assertNotNull((Object)bundle);
        }
    }

    @Test
    public void ensurePluginxmlContainsAtLeastOneEntry() throws Exception {
        for (String bundleSymbolicName : this.bundlesWithPluginXml) {
            Bundle bundle = PluginWalkerTest.getBundle(this.bundleContext, bundleSymbolicName);
            Document doc = PluginWalkerTest.getDocument(bundle);
            NodeList extensions = doc.getElementsByTagName("extension");
            NodeList extensionpoint = doc.getElementsByTagName("extension-point");
            boolean hasExtension = extensions.getLength() > 0;
            boolean hasExtensionPoint = extensionpoint.getLength() > 0;
            Assert.assertTrue((String)("plugin.xml from " + bundleSymbolicName + "  must contain at least one extension point or extension"), (hasExtension || hasExtensionPoint ? 1 : 0) != 0);
        }
    }

    @Test
    public void ensureExtensionPointClassesAreAccessable() throws Exception {
        for (String bundleSymbolicName : this.bundlesWithPluginXml) {
            IExtensionPoint[] extensionPoints;
            IExtensionRegistry registry = RegistryFactory.getRegistry();
            IExtensionPoint[] iExtensionPointArray = extensionPoints = registry.getExtensionPoints();
            int n = extensionPoints.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configurationElements;
                IExtensionPoint point = iExtensionPointArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configurationElements = point.getConfigurationElements();
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String clsSpec;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    IExtension declaringExtension = element.getDeclaringExtension();
                    String name = declaringExtension.getContributor().getName();
                    if (name.equals(bundleSymbolicName) && (clsSpec = element.getAttribute("class")) != null && clsSpec.length() > 0) {
                        Collection<BundleWiring> wirings = this.findWirings(bundleSymbolicName, this.bundleContext);
                        int indexLastColumn = clsSpec.lastIndexOf(58);
                        if (indexLastColumn != -1) {
                            clsSpec = clsSpec.substring(0, indexLastColumn);
                        }
                        System.out.println(clsSpec);
                        int indexLastDot = clsSpec.lastIndexOf(46);
                        String classPackageName = String.valueOf('/') + clsSpec.substring(0, indexLastDot).replace('.', '/');
                        String classResourceName = String.valueOf(clsSpec.substring(indexLastDot + 1)) + ".class";
                        for (BundleWiring bundleWiring : wirings) {
                            if (this.checkClassResource(classPackageName, classResourceName, bundleWiring)) continue;
                            Assert.fail((String)("Class " + clsSpec + " not found"));
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static InputStream getPluginXml(Bundle bundle) throws IOException {
        URL entry = bundle.getEntry("plugin.xml");
        return entry.openConnection().getInputStream();
    }

    private static Bundle getBundle(BundleContext bundleContext, String symbolicName) {
        Bundle result = null;
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle candidate = bundleArray[n2];
            if (candidate.getSymbolicName().equals(symbolicName) && (result == null || result.getVersion().compareTo(candidate.getVersion()) < 0)) {
                result = candidate;
            }
            ++n2;
        }
        return result;
    }

    private static Document getDocument(Bundle bundle) throws SAXException, IOException, ParserConfigurationException {
        Document doc = null;
        DocumentBuilder builder = PluginWalkerTest.createDocumentBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream pluginXml = PluginWalkerTest.getPluginXml(bundle);){
            Assert.assertNotNull((Object)pluginXml);
            doc = builder.parse(pluginXml);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return doc;
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder;
    }

    private Collection<BundleWiring> findWirings(final String bundleSymbolicName, BundleContext bundleContext) {
        Requirement req = new Requirement(){

            public Resource getResource() {
                return null;
            }

            public String getNamespace() {
                return "osgi.identity";
            }

            public Map<String, String> getDirectives() {
                return Collections.singletonMap("filter", "(osgi.identity=" + bundleSymbolicName + ")");
            }

            public Map<String, Object> getAttributes() {
                return Collections.emptyMap();
            }
        };
        Collection identities = ((FrameworkWiring)bundleContext.getBundle("System Bundle").adapt(FrameworkWiring.class)).findProviders(req);
        ArrayList<BundleWiring> result = new ArrayList<BundleWiring>(1);
        for (BundleCapability identity : identities) {
            BundleRevision revision = identity.getRevision();
            BundleWiring wiring = revision.getWiring();
            if (wiring == null) continue;
            if ((revision.getTypes() & 1) != 0) {
                wiring = ((BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0)).getProviderWiring();
            }
            result.add(wiring);
        }
        return result;
    }

    private boolean checkClassResource(String classPackageName, String classFileName, BundleWiring wiring) {
        Collection classResourcePaths;
        if (wiring == null) {
            return false;
        }
        if ((wiring.getRevision().getTypes() & 1) != 0) {
            wiring = ((BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0)).getProviderWiring();
        }
        return (classResourcePaths = wiring.listResources(classPackageName, classFileName, 0)) != null && !classResourcePaths.isEmpty();
    }
}

