/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IWorkbenchPageTest {
    private Display display = null;

    @Before
    public void setUp() throws Exception {
        Assert.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)this.display);
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertNotNull((Object)this.display);
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void test70080() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
                super.preWindowOpen(configurer);
                configurer.setShowPerspectiveBar(false);
            }

            @Override
            public void postStartup() {
                try {
                    IWorkbenchWindow window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = window.getActivePage();
                    page.showView("org.eclipse.ui.tests.rcp.util.EmptyView");
                    Assert.assertNotNull((Object)page.findView("org.eclipse.ui.tests.rcp.util.EmptyView"));
                    page.resetPerspective();
                    Assert.assertNull((Object)page.findView("org.eclipse.ui.tests.rcp.util.EmptyView"));
                }
                catch (PartInitException e) {
                    Assert.fail((String)e.toString());
                }
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
    }
}

