/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.tests.rcp.WorkbenchAdvisorExceptionObserver;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class WorkbenchAdvisorTest {
    private Display display = null;

    @Before
    public void setUp() {
        Assert.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)this.display);
    }

    @After
    public void tearDown() {
        Assert.assertNotNull((Object)this.display);
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void testEarlyGetWorkbench() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer configurer) {
                super.initialize(configurer);
                Assert.assertNotNull((Object)PlatformUI.getWorkbench());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
    }

    @Test
    public void testTwoDisplays() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1);
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
        Assert.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)this.display);
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1);
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assert.assertEquals((long)0L, (long)code2);
    }

    @Test
    public void testTrivialOpenClose() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){
            private boolean windowOpenCalled;
            private boolean windowCloseCalled;
            {
                this.windowOpenCalled = false;
                this.windowCloseCalled = false;
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowActivated(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                        windowCloseCalled = true;
                    }

                    public void windowOpened(IWorkbenchWindow window) {
                        windowOpenCalled = true;
                    }
                });
            }

            @Override
            public void preWindowOpen(IWorkbenchWindowConfigurer c) {
                Assert.assertFalse((boolean)this.windowOpenCalled);
                super.preWindowOpen(c);
            }

            @Override
            public void postWindowOpen(IWorkbenchWindowConfigurer c) {
                Assert.assertTrue((boolean)this.windowOpenCalled);
                super.postWindowOpen(c);
            }

            @Override
            public boolean preWindowShellClose(IWorkbenchWindowConfigurer c) {
                Assert.assertFalse((boolean)this.windowCloseCalled);
                return super.preWindowShellClose(c);
            }

            public void postWindowClose(IWorkbenchWindowConfigurer c) {
                super.postWindowClose(c);
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
        wa.resetOperationIterator();
        wa.assertNextOperation("initialize");
        wa.assertNextOperation("preStartup");
        wa.assertNextOperation("preWindowOpen");
        wa.assertNextOperation("fillActionBars");
        wa.assertNextOperation("postWindowOpen");
        wa.assertNextOperation("postStartup");
        wa.assertNextOperation("preShutdown");
        wa.assertNextOperation("postShutdown");
        wa.assertAllOperationsExamined();
    }

    @Test
    public void testTrivialRestoreClose() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }

            public void eventLoopIdle(Display d) {
                this.workbenchConfig.getWorkbench().restart();
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)1L, (long)code);
        Assert.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }
        };
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assert.assertEquals((long)0L, (long)code2);
        wa2.resetOperationIterator();
        wa2.assertNextOperation("initialize");
        wa2.assertNextOperation("preStartup");
        wa2.assertNextOperation("preWindowOpen");
        wa2.assertNextOperation("fillActionBars");
        wa2.assertNextOperation("postWindowOpen");
        wa2.assertNextOperation("postStartup");
        wa2.assertNextOperation("preShutdown");
        wa2.assertNextOperation("postShutdown");
        wa2.assertAllOperationsExamined();
    }

    @Test
    public void testCloseFromPostStartup() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void postStartup() {
                super.postStartup();
                Assert.assertTrue((boolean)PlatformUI.getWorkbench().close());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
        wa.resetOperationIterator();
        wa.assertNextOperation("initialize");
        wa.assertNextOperation("preStartup");
        wa.assertNextOperation("preWindowOpen");
        wa.assertNextOperation("fillActionBars");
        wa.assertNextOperation("postWindowOpen");
        wa.assertNextOperation("postStartup");
        wa.assertNextOperation("preShutdown");
        wa.assertNextOperation("postShutdown");
        wa.assertAllOperationsExamined();
    }

    @Test
    public void testEventLoopCrash() {
        WorkbenchAdvisorExceptionObserver wa = new WorkbenchAdvisorExceptionObserver();
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
        Assert.assertTrue((boolean)wa.exceptionCaught);
    }

    @Test
    public void testFillAllActionBar() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
                super.fillActionBars(window, configurer, flags);
                Assert.assertEquals((long)4L, (long)(flags & 4));
                Assert.assertEquals((long)2L, (long)(flags & 2));
                Assert.assertEquals((long)8L, (long)(flags & 8));
                Assert.assertEquals((long)0L, (long)(flags & 1));
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
    }

    @Test
    public void testEmptyProgressRegion() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
                super.preWindowOpen(configurer);
                configurer.setShowProgressIndicator(false);
            }

            @Override
            public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
                try {
                    ProgressManagerUtil.animateUp((Rectangle)new Rectangle(0, 0, 100, 50));
                }
                catch (NullPointerException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
    }

    @Ignore
    @Test
    public void testShellClose() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(){

            public void eventLoopIdle(Display disp) {
                Shell[] shells;
                super.eventLoopIdle(disp);
                Shell[] shellArray = shells = disp.getShells();
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (shell != null) {
                        shell.close();
                    }
                    ++n2;
                }
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
        wa.resetOperationIterator();
        wa.assertNextOperation("initialize");
        wa.assertNextOperation("preStartup");
        wa.assertNextOperation("preWindowOpen");
        wa.assertNextOperation("fillActionBars");
        wa.assertNextOperation("postWindowOpen");
        wa.assertNextOperation("postStartup");
        wa.assertNextOperation("preWindowShellClose");
        wa.assertNextOperation("preShutdown");
        wa.assertNextOperation("postShutdown");
        wa.assertAllOperationsExamined();
    }
}

