/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class WorkbenchSaveRestoreStateTest {
    private static final String ADVISOR_STATE_KEY = "advisorStateKey";
    private static final String WINDOW_ADVISOR_STATE_KEY = "windowAdvisorStateKey";
    private static final String ACTIONBAR_ADVISOR_STATE_KEY = "actionBarAdvisorStateKey";
    private Display display = null;

    @Before
    public void setUp() throws Exception {
        Assert.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)this.display);
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertNotNull((Object)this.display);
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void testSaveRestoreAdvisorState() {
        final String advisorStateData = Long.toString(System.currentTimeMillis());
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            public IStatus saveState(IMemento memento) {
                Assert.assertNotNull((Object)memento);
                memento.putString(WorkbenchSaveRestoreStateTest.ADVISOR_STATE_KEY, advisorStateData);
                return super.saveState(memento);
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }

            public void eventLoopIdle(Display d) {
                this.workbenchConfig.getWorkbench().restart();
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)1L, (long)code);
        Assert.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1){

            public IStatus restoreState(IMemento memento) {
                Assert.assertNotNull((Object)memento);
                String stateData = memento.getString(WorkbenchSaveRestoreStateTest.ADVISOR_STATE_KEY);
                Assert.assertNotNull((Object)stateData);
                Assert.assertTrue((boolean)advisorStateData.equals(stateData));
                return super.restoreState(memento);
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }
        };
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assert.assertEquals((long)0L, (long)code2);
    }

    @Test
    public void testSaveRestoreWindowState() {
        final String advisorStateData = Long.toString(System.currentTimeMillis());
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                return new WorkbenchWindowAdvisor(configurer){

                    public IStatus saveState(IMemento memento) {
                        Assert.assertNotNull((Object)memento);
                        memento.putString(WorkbenchSaveRestoreStateTest.WINDOW_ADVISOR_STATE_KEY, advisorStateData);
                        return super.saveState(memento);
                    }
                };
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }

            public void eventLoopIdle(Display d) {
                this.workbenchConfig.getWorkbench().restart();
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)1L, (long)code);
        Assert.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1){

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                return new WorkbenchWindowAdvisor(configurer){

                    public IStatus restoreState(IMemento memento) {
                        Assert.assertNotNull((Object)memento);
                        String stateData = memento.getString(WorkbenchSaveRestoreStateTest.WINDOW_ADVISOR_STATE_KEY);
                        Assert.assertNotNull((Object)stateData);
                        Assert.assertTrue((boolean)advisorStateData.equals(stateData));
                        return super.restoreState(memento);
                    }
                };
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }
        };
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assert.assertEquals((long)0L, (long)code2);
    }

    @Test
    public void testSaveRestoreActionBarState() {
        final String advisorStateData = Long.toString(System.currentTimeMillis());
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                return new WorkbenchWindowAdvisor(configurer){

                    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer1) {
                        return new ActionBarAdvisor(configurer1){

                            public IStatus saveState(IMemento memento) {
                                Assert.assertNotNull((Object)memento);
                                memento.putString(WorkbenchSaveRestoreStateTest.ACTIONBAR_ADVISOR_STATE_KEY, advisorStateData);
                                return super.saveState(memento);
                            }
                        };
                    }
                };
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }

            public void eventLoopIdle(Display d) {
                this.workbenchConfig.getWorkbench().restart();
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)1L, (long)code);
        Assert.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1){

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                return new WorkbenchWindowAdvisor(configurer){

                    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer1) {
                        return new ActionBarAdvisor(configurer1){

                            public IStatus restoreState(IMemento memento) {
                                Assert.assertNotNull((Object)memento);
                                String stateData = memento.getString(WorkbenchSaveRestoreStateTest.ACTIONBAR_ADVISOR_STATE_KEY);
                                Assert.assertNotNull((Object)stateData);
                                Assert.assertTrue((boolean)advisorStateData.equals(stateData));
                                return super.restoreState(memento);
                            }
                        };
                    }
                };
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }
        };
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assert.assertEquals((long)0L, (long)code2);
    }

    @Ignore
    @Test
    public void testOnDemandSaveRestoreState() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }

            public void eventLoopIdle(Display d) {
                this.workbenchConfig.getWorkbench().restart();
            }

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                return new WorkbenchWindowAdvisor(configurer){

                    public void postWindowOpen() {
                        File stateLocation = WorkbenchSaveRestoreStateTest.this.getStateFileLocation();
                        WorkbenchSaveRestoreStateTest.this.ensureDirectoryExists(stateLocation);
                        String stateFileName = String.valueOf(stateLocation.getPath()) + File.separator + "testOnDemandSaveRestoreState.xml";
                        OutputStreamWriter writer = null;
                        try {
                            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(stateFileName), StandardCharsets.UTF_8);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        XMLMemento xmlm = XMLMemento.createWriteRoot((String)"TestState");
                        this.saveState((IMemento)xmlm);
                        try {
                            xmlm.save((Writer)writer);
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)1L, (long)code);
        Assert.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }

            public boolean openWindows() {
                File stateLocation = WorkbenchSaveRestoreStateTest.this.getStateFileLocation();
                String stateFileName = "testOnDemandSaveRestoreState.xml";
                File stateFile = new File(String.valueOf(stateLocation.getPath()) + File.separator + stateFileName);
                Assert.assertTrue((boolean)stateFile.exists());
                XMLMemento memento = null;
                try {
                    memento = XMLMemento.createReadRoot((Reader)new InputStreamReader((InputStream)new FileInputStream(stateFile), StandardCharsets.UTF_8));
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException fileNotFoundException) {}
                Assert.assertNotNull(memento);
                IWorkbenchWindowConfigurer window = null;
                try {
                    window = this.getWorkbenchConfigurer().restoreWorkbenchWindow((IMemento)memento);
                }
                catch (WorkbenchException e) {
                    e.printStackTrace();
                }
                Assert.assertNotNull((Object)window);
                return true;
            }

            @Override
            public void postWindowRestore(IWorkbenchWindowConfigurer configurer) throws WorkbenchException {
                super.postWindowRestore(configurer);
            }
        };
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assert.assertEquals((long)0L, (long)code2);
    }

    private File getStateFileLocation() {
        IPath path = UIPlugin.getDefault().getStateLocation();
        StringBuilder fileName = new StringBuilder();
        fileName.append(File.separator);
        fileName.append("TestWorkbenchState");
        fileName.append(File.separator);
        File stateLocation = path.append(fileName.toString()).toFile();
        this.ensureDirectoryExists(stateLocation);
        return stateLocation;
    }

    private void ensureDirectoryExists(File directory) {
        directory.mkdirs();
    }
}

