/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.tests.harness.util.RCPTestWorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkbenchWindowConfigurerTest {
    private Display display = null;

    @Before
    public void setUp() throws Exception {
        Assert.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assert.assertNotNull((Object)this.display);
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertNotNull((Object)this.display);
        this.display.dispose();
        Assert.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void testDefaults() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer actionBarConfig, int flags) {
                super.fillActionBars(window, actionBarConfig, flags);
                String tempTitle = "title";
                IWorkbenchWindowConfigurer windowConfig = this.workbenchConfig.getWindowConfigurer(window);
                Assert.assertNotNull((Object)windowConfig);
                Assert.assertEquals((Object)window, (Object)windowConfig.getWindow());
                Assert.assertEquals((Object)this.workbenchConfig, (Object)windowConfig.getWorkbenchConfigurer());
                Assert.assertEquals((Object)actionBarConfig, (Object)windowConfig.getActionBarConfigurer());
                Assert.assertNotNull((Object)windowConfig.getTitle());
                Assert.assertTrue((boolean)windowConfig.getShowCoolBar());
                Assert.assertTrue((boolean)windowConfig.getShowMenuBar());
                Assert.assertFalse((boolean)windowConfig.getShowPerspectiveBar());
                Assert.assertTrue((boolean)windowConfig.getShowStatusLine());
                windowConfig.setTitle(tempTitle);
                windowConfig.setShowCoolBar(false);
                windowConfig.setShowMenuBar(false);
                windowConfig.setShowPerspectiveBar(true);
                windowConfig.setShowStatusLine(false);
                Assert.assertEquals((Object)tempTitle, (Object)windowConfig.getTitle());
                Assert.assertFalse((boolean)windowConfig.getShowCoolBar());
                Assert.assertFalse((boolean)windowConfig.getShowMenuBar());
                Assert.assertTrue((boolean)windowConfig.getShowPerspectiveBar());
                Assert.assertFalse((boolean)windowConfig.getShowStatusLine());
                windowConfig.setTitle("");
                windowConfig.setShowCoolBar(true);
                windowConfig.setShowMenuBar(true);
                windowConfig.setShowPerspectiveBar(false);
                windowConfig.setShowStatusLine(true);
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
    }

    @Test
    public void test104558_T_T() throws Throwable {
        this.doTest104558(true, true);
    }

    @Test
    public void test104558_F_T() throws Throwable {
        this.doTest104558(false, true);
    }

    @Test
    public void test104558_T_F() throws Throwable {
        this.doTest104558(true, false);
    }

    @Test
    public void test104558_F_F() throws Throwable {
        this.doTest104558(false, false);
    }

    private void doTest104558(final boolean showPerspectiveBar, final boolean showCoolBar) {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer workbenchWindowConfigurer) {
                return new WorkbenchWindowAdvisor(workbenchWindowConfigurer){

                    public void preWindowOpen() {
                        super.preWindowOpen();
                        this.getWindowConfigurer().setShowCoolBar(showCoolBar);
                        this.getWindowConfigurer().setShowPerspectiveBar(showPerspectiveBar);
                    }

                    public void createWindowContents(Shell shell) {
                        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
                        configurer.createPageComposite((Composite)shell);
                    }
                };
            }

            public void eventLoopIdle(Display disp) {
                IWorkbenchWindow activeWorkbenchWindow = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
                Assert.assertEquals((String)("testing showCoolBar=" + showCoolBar), (Object)showCoolBar, (Object)((WorkbenchWindow)activeWorkbenchWindow).getCoolBarVisible());
                Assert.assertEquals((String)("testing showPerspectiveBar=" + showPerspectiveBar), (Object)showPerspectiveBar, (Object)((WorkbenchWindow)activeWorkbenchWindow).getPerspectiveBarVisible());
                super.eventLoopIdle(disp);
            }

            @Override
            public void eventLoopException(Throwable exception) {
                throw new RuntimeException(exception);
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assert.assertEquals((long)0L, (long)code);
    }

    @Test
    public void testThreading() {
        final ArrayList results = new ArrayList();
        RCPTestWorkbenchAdvisor advisor = new RCPTestWorkbenchAdvisor(1){

            public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
                WorkbenchWindowAdvisor advisor = new WorkbenchWindowAdvisor(configurer){

                    private void ensureThread() {
                        if (Display.getCurrent() != null) {
                            return;
                        }
                        Exception e = new Exception();
                        e.fillInStackTrace();
                        StackTraceElement element = e.getStackTrace()[1];
                        results.add(String.valueOf(element.getClassName()) + '.' + element.getMethodName());
                    }

                    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
                        this.ensureThread();
                        ActionBarAdvisor advisor = new ActionBarAdvisor(configurer){

                            public void dispose() {
                                this.ensureThread();
                                super.dispose();
                            }

                            protected void disposeAction(IAction action) {
                                this.ensureThread();
                                super.disposeAction(action);
                            }

                            protected void disposeActions() {
                                this.ensureThread();
                                super.disposeActions();
                            }

                            public void fillActionBars(int flags) {
                                this.ensureThread();
                                super.fillActionBars(flags);
                            }

                            protected void fillCoolBar(ICoolBarManager coolBar) {
                                this.ensureThread();
                                super.fillCoolBar(coolBar);
                            }

                            protected void fillMenuBar(IMenuManager menuBar) {
                                this.ensureThread();
                                super.fillMenuBar(menuBar);
                            }

                            protected void fillStatusLine(IStatusLineManager statusLine) {
                                this.ensureThread();
                                super.fillStatusLine(statusLine);
                            }

                            protected IAction getAction(String id) {
                                this.ensureThread();
                                return super.getAction(id);
                            }

                            protected IActionBarConfigurer getActionBarConfigurer() {
                                this.ensureThread();
                                return super.getActionBarConfigurer();
                            }

                            public boolean isApplicationMenu(String menuId) {
                                this.ensureThread();
                                return super.isApplicationMenu(menuId);
                            }

                            protected void makeActions(IWorkbenchWindow window) {
                                this.ensureThread();
                                super.makeActions(window);
                            }

                            protected void register(IAction action) {
                                this.ensureThread();
                                super.register(action);
                            }

                            public IStatus restoreState(IMemento memento) {
                                this.ensureThread();
                                return super.restoreState(memento);
                            }

                            public IStatus saveState(IMemento memento) {
                                this.ensureThread();
                                return super.saveState(memento);
                            }
                        };
                        return advisor;
                    }

                    public Control createEmptyWindowContents(Composite parent) {
                        this.ensureThread();
                        return super.createEmptyWindowContents(parent);
                    }

                    public void createWindowContents(Shell shell) {
                        this.ensureThread();
                        super.createWindowContents(shell);
                    }

                    public void dispose() {
                        this.ensureThread();
                        super.dispose();
                    }

                    protected IWorkbenchWindowConfigurer getWindowConfigurer() {
                        this.ensureThread();
                        return super.getWindowConfigurer();
                    }

                    public void openIntro() {
                        this.ensureThread();
                        super.openIntro();
                    }

                    public void postWindowClose() {
                        this.ensureThread();
                        super.postWindowClose();
                    }

                    public void postWindowCreate() {
                        this.ensureThread();
                        super.postWindowCreate();
                    }

                    public void postWindowOpen() {
                        this.ensureThread();
                        super.postWindowOpen();
                    }

                    public void postWindowRestore() throws WorkbenchException {
                        this.ensureThread();
                        super.postWindowRestore();
                    }

                    public void preWindowOpen() {
                        this.ensureThread();
                        super.preWindowOpen();
                    }

                    public boolean preWindowShellClose() {
                        this.ensureThread();
                        return super.preWindowShellClose();
                    }

                    public IStatus restoreState(IMemento memento) {
                        this.ensureThread();
                        return super.restoreState(memento);
                    }

                    public IStatus saveState(IMemento memento) {
                        this.ensureThread();
                        return super.saveState(memento);
                    }
                };
                return advisor;
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)advisor);
        Assert.assertEquals((long)0L, (long)code);
        if (!results.isEmpty()) {
            StringBuilder buffer = new StringBuilder("Window/action bar advisor methods called from non-UI threads:\n");
            for (String string : results) {
                buffer.append(string).append('\n');
            }
            Assert.fail((String)buffer.toString());
        }
    }
}

