/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp.performance;

import junit.framework.TestCase;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.util.OpenWorkbenchIntervalMonitor;
import org.eclipse.ui.tests.rcp.util.RestoreWorkbenchIntervalMonitor;

public class EmptyWorkbenchPerfTest
extends PerformanceTestCase {
    private static final int REPEAT_COUNT = 25;

    public void testOpen() {
        Display display = PlatformUI.createDisplay();
        Performance perf = Performance.getDefault();
        String baseScenarioId = perf.getDefaultScenarioId((TestCase)this);
        PerformanceMeter startupMeter = perf.createPerformanceMeter(String.valueOf(baseScenarioId) + " [open]");
        PerformanceMeter shutdownMeter = perf.createPerformanceMeter(String.valueOf(baseScenarioId) + " [close]");
        this.tagAsSummary("Open RCP App", Dimension.CPU_TIME);
        int i = 0;
        while (i < 25) {
            startupMeter.start();
            int code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new OpenWorkbenchIntervalMonitor(startupMeter, shutdownMeter));
            shutdownMeter.stop();
            EmptyWorkbenchPerfTest.assertEquals((int)0, (int)code);
            ++i;
        }
        display.dispose();
        EmptyWorkbenchPerfTest.assertTrue((boolean)display.isDisposed());
        startupMeter.commit();
        perf.assertPerformance(startupMeter);
        perf.assertPerformanceInAbsoluteBand(shutdownMeter, Dimension.CPU_TIME, 0, 120);
        startupMeter.dispose();
        shutdownMeter.dispose();
    }

    public void testRestore() {
        Display display = PlatformUI.createDisplay();
        Performance perf = Performance.getDefault();
        String baseScenarioId = perf.getDefaultScenarioId((TestCase)this);
        PerformanceMeter startupMeter = perf.createPerformanceMeter(String.valueOf(baseScenarioId) + " [open]");
        PerformanceMeter shutdownMeter = perf.createPerformanceMeter(String.valueOf(baseScenarioId) + " [close]");
        PerformanceMeter startupMeter0 = perf.createPerformanceMeter(String.valueOf(baseScenarioId) + " [0][open]");
        PerformanceMeter shutdownMeter0 = perf.createPerformanceMeter(String.valueOf(baseScenarioId) + " [0][close]");
        RestoreWorkbenchIntervalMonitor wa = new RestoreWorkbenchIntervalMonitor(startupMeter0, shutdownMeter0, true);
        int code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)wa);
        EmptyWorkbenchPerfTest.assertEquals((int)1, (int)code);
        EmptyWorkbenchPerfTest.assertFalse((boolean)display.isDisposed());
        startupMeter0.dispose();
        shutdownMeter0.dispose();
        this.tagAsSummary("Restore RCP App", Dimension.CPU_TIME);
        int i = 0;
        while (i < 25) {
            startupMeter.start();
            code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new RestoreWorkbenchIntervalMonitor(startupMeter, shutdownMeter, false));
            shutdownMeter.stop();
            EmptyWorkbenchPerfTest.assertEquals((int)0, (int)code);
            ++i;
        }
        display.dispose();
        EmptyWorkbenchPerfTest.assertTrue((boolean)display.isDisposed());
        startupMeter.commit();
        perf.assertPerformance(startupMeter);
        perf.assertPerformanceInAbsoluteBand(shutdownMeter, Dimension.CPU_TIME, 0, 120);
        startupMeter.dispose();
        shutdownMeter.dispose();
    }
}

