/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.tests.harness.util.RCPTestWorkbenchAdvisor;
import org.junit.Assert;

public class WorkbenchAdvisorObserver
extends RCPTestWorkbenchAdvisor {
    private List<String> operations = new LinkedList<String>();
    private Iterator<String> iterator;
    public static final String INITIALIZE = "initialize";
    public static final String PRE_STARTUP = "preStartup";
    public static final String POST_STARTUP = "postStartup";
    public static final String PRE_WINDOW_OPEN = "preWindowOpen";
    public static final String FILL_ACTION_BARS = "fillActionBars";
    public static final String POST_WINDOW_RESTORE = "postWindowRestore";
    public static final String POST_WINDOW_OPEN = "postWindowOpen";
    public static final String PRE_WINDOW_SHELL_CLOSE = "preWindowShellClose";
    public static final String EVENT_LOOP_EXCEPTION = "eventLoopException";
    public static final String PRE_SHUTDOWN = "preShutdown";
    public static final String POST_SHUTDOWN = "postShutdown";
    public IWorkbenchConfigurer workbenchConfig;

    public WorkbenchAdvisorObserver() {
    }

    public WorkbenchAdvisorObserver(int idleBeforeExit) {
        super(idleBeforeExit);
    }

    public void resetOperationIterator() {
        this.iterator = this.operations.iterator();
    }

    public void assertNextOperation(String expected) {
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals((Object)expected, (Object)this.iterator.next());
    }

    public void assertAllOperationsExamined() {
        Assert.assertNotNull(this.iterator);
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    private void addOperation(String operation) {
        this.operations.add(operation);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        this.workbenchConfig = configurer;
        this.addOperation(INITIALIZE);
    }

    public void preStartup() {
        super.preStartup();
        this.addOperation(PRE_STARTUP);
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
        super.preWindowOpen(configurer);
        this.addOperation(PRE_WINDOW_OPEN);
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
        super.fillActionBars(window, configurer, flags);
        this.addOperation(FILL_ACTION_BARS);
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer configurer) throws WorkbenchException {
        super.postWindowRestore(configurer);
        this.addOperation(POST_WINDOW_RESTORE);
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
        super.postWindowOpen(configurer);
        this.addOperation(POST_WINDOW_OPEN);
    }

    public void postStartup() {
        super.postStartup();
        this.addOperation(POST_STARTUP);
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer configurer) {
        if (!super.preWindowShellClose(configurer)) {
            return false;
        }
        this.addOperation(PRE_WINDOW_SHELL_CLOSE);
        return true;
    }

    public boolean preShutdown() {
        boolean result = super.preShutdown();
        this.addOperation(PRE_SHUTDOWN);
        return result;
    }

    public void postShutdown() {
        super.postShutdown();
        this.addOperation(POST_SHUTDOWN);
    }

    public void eventLoopException(Throwable exception) {
        super.eventLoopException(exception);
        this.addOperation(EVENT_LOOP_EXCEPTION);
    }
}

