/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import junit.framework.TestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyComposite;
import org.eclipse.ui.tests.views.properties.tabbed.decorations.TabbedPropertySheetPageWithDecorations;
import org.eclipse.ui.tests.views.properties.tabbed.decorations.views.DecorationTestsView;
import org.eclipse.ui.tests.views.properties.tabbed.views.TestsViewContentProvider;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

public class TabbedPropertySheetPageDecorationsTest
extends TestCase {
    private DecorationTestsView decorationTestsView;
    private TreeNode[] treeNodes;

    protected void setUp() throws Exception {
        super.setUp();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TabbedPropertySheetPageDecorationsTest.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        TabbedPropertySheetPageDecorationsTest.assertNotNull((Object)workbenchPage);
        this.closeIntroView(workbenchPage);
        this.processUiEvents();
        workbenchPage.closeAllPerspectives(false, false);
        this.processUiEvents();
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        this.processUiEvents();
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.decorations.views.DecorationTestsView");
        this.processUiEvents();
        TabbedPropertySheetPageDecorationsTest.assertNotNull((Object)view);
        TabbedPropertySheetPageDecorationsTest.assertTrue((boolean)(view instanceof DecorationTestsView));
        TabbedPropertySheetPageDecorationsTest.assertTrue((boolean)workbenchPage.isPartVisible((IWorkbenchPart)view));
        this.decorationTestsView = (DecorationTestsView)view;
        IContentProvider contentProvider = this.decorationTestsView.getViewer().getContentProvider();
        TabbedPropertySheetPageDecorationsTest.assertTrue((boolean)(contentProvider instanceof TestsViewContentProvider));
        TestsViewContentProvider viewContentProvider = (TestsViewContentProvider)contentProvider;
        this.treeNodes = viewContentProvider.getInvisibleRoot().getChildren();
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)this.treeNodes.length, (int)8);
    }

    private void closeIntroView(IWorkbenchPage workbenchPage) {
        IViewPart intro = workbenchPage.findView("org.eclipse.ui.internal.introview");
        if (intro != null) {
            workbenchPage.hideView(intro);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.processUiEvents();
        this.setSelection(new TreeNode[0]);
    }

    private void processUiEvents() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    private void setSelection(TreeNode[] selectedNodes) {
        StructuredSelection selection = new StructuredSelection((Object[])selectedNodes);
        this.decorationTestsView.getViewer().setSelection((ISelection)selection, true);
    }

    public void test_widestLabelIndex1_WithoutDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(false);
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Name", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Information", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Message", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)3, (int)tabDescriptors.length);
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)1, (int)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    public void test_widestLabelIndex1_WithDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(true);
        this.setSelection(new TreeNode[]{this.treeNodes[0]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Name", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Information", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Message", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)3, (int)tabDescriptors.length);
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)0, (int)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    public void test_widestLabelIndex2_WithoutDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(false);
        this.setSelection(new TreeNode[]{this.treeNodes[0], this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Information", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Message", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)2, (int)tabDescriptors.length);
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)0, (int)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }

    public void test_widestLabelIndex2_WithDecorations() {
        ((TabbedPropertySheetPageWithDecorations)this.decorationTestsView.getTabbedPropertySheetPage()).useDecorations(true);
        this.setSelection(new TreeNode[]{this.treeNodes[0], this.treeNodes[1]});
        ITabDescriptor[] tabDescriptors = this.decorationTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Information", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((String)"Message", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)2, (int)tabDescriptors.length);
        TabbedPropertySheetPageDecorationsTest.assertEquals((int)1, (int)((TabbedPropertyComposite)this.decorationTestsView.getTabbedPropertySheetPage().getControl()).getList().getWidestLabelIndex());
    }
}

