/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsColor;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsElement;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsShape;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsTreeNode;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsView;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsViewContentProvider;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;

public class TabbedPropertySheetPageDynamicTest
extends TestCase {
    private DynamicTestsView dynamicTestsView;
    private DynamicTestsTreeNode[] treeNodes;

    protected void setUp() throws Exception {
        super.setUp();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TabbedPropertySheetPageDynamicTest.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        TabbedPropertySheetPageDynamicTest.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsView");
        TabbedPropertySheetPageDynamicTest.assertNotNull((Object)view);
        TabbedPropertySheetPageDynamicTest.assertTrue((boolean)(view instanceof DynamicTestsView));
        this.dynamicTestsView = (DynamicTestsView)view;
        IContentProvider contentProvider = this.dynamicTestsView.getViewer().getContentProvider();
        TabbedPropertySheetPageDynamicTest.assertTrue((boolean)(contentProvider instanceof DynamicTestsViewContentProvider));
        DynamicTestsViewContentProvider viewContentProvider = (DynamicTestsViewContentProvider)contentProvider;
        this.treeNodes = (DynamicTestsTreeNode[])viewContentProvider.getInvisibleRoot().getChildren();
        TabbedPropertySheetPageDynamicTest.assertEquals((int)this.treeNodes.length, (int)11);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        while (Display.getCurrent().readAndDispatch()) {
        }
        this.setSelection(new DynamicTestsTreeNode[0]);
    }

    private void setSelection(DynamicTestsTreeNode[] selectedNodes) {
        StructuredSelection selection = new StructuredSelection((Object[])selectedNodes);
        this.dynamicTestsView.getViewer().setSelection((ISelection)selection, true);
    }

    public void test_BlueStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_all_blue();
    }

    public void test_BlueDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_all_blue();
    }

    public void test_BlueDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_all_blue();
    }

    public void select_all_blue() {
        ArrayList<DynamicTestsTreeNode> blueList = new ArrayList<DynamicTestsTreeNode>();
        int i = 0;
        while (i < this.treeNodes.length) {
            if (DynamicTestsColor.BLUE.equals(this.treeNodes[i].getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_COLOR))) {
                blueList.add(this.treeNodes[i]);
            }
            ++i;
        }
        DynamicTestsTreeNode[] selectNodes = blueList.toArray(new DynamicTestsTreeNode[blueList.size()]);
        TabbedPropertySheetPageDynamicTest.assertEquals((int)blueList.size(), (int)3);
        this.setSelection(selectNodes);
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Element", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Color", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((int)2, (int)tabDescriptors.length);
    }

    public void test_TriangleStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_all_triangle();
    }

    public void test_TriangleDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_all_triangle();
    }

    public void test_TriangleDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_all_triangle();
    }

    public void select_all_triangle() {
        ArrayList<DynamicTestsTreeNode> triangleList = new ArrayList<DynamicTestsTreeNode>();
        int i = 0;
        while (i < this.treeNodes.length) {
            if (DynamicTestsShape.TRIANGLE.equals(this.treeNodes[i].getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_SHAPE))) {
                triangleList.add(this.treeNodes[i]);
            }
            ++i;
        }
        DynamicTestsTreeNode[] selectNodes = triangleList.toArray(new DynamicTestsTreeNode[triangleList.size()]);
        TabbedPropertySheetPageDynamicTest.assertEquals((int)triangleList.size(), (int)4);
        this.setSelection(selectNodes);
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Element", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Shape", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((int)2, (int)tabDescriptors.length);
    }

    public void test_BlackTriangleStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_blackTriangle();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((int)3, (int)tabDescriptors.length);
    }

    public void test_BlackTriangleDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_blackTriangle();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Black", (String)tabDescriptors[3].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((int)4, (int)tabDescriptors.length);
    }

    public void test_BlackTriangleDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_blackTriangle();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((int)3, (int)tabDescriptors.length);
    }

    public void select_blackTriangle() {
        DynamicTestsTreeNode blackTriangleNode = null;
        int i = 0;
        while (i < this.treeNodes.length) {
            if (DynamicTestsColor.BLACK.equals(this.treeNodes[i].getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_COLOR))) {
                blackTriangleNode = this.treeNodes[i];
                break;
            }
            ++i;
        }
        TabbedPropertySheetPageDynamicTest.assertNotNull(blackTriangleNode);
        this.setSelection(new DynamicTestsTreeNode[]{blackTriangleNode});
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Element", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Shape", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Advanced", (String)tabDescriptors[2].getLabel());
    }

    public void test_RedStarStaticContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.static");
        this.select_RedStar();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Advanced", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((int)3, (int)tabDescriptors.length);
    }

    public void test_RedStarDynamicTabContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab");
        this.select_RedStar();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Advanced", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((int)3, (int)tabDescriptors.length);
    }

    public void test_RedStarDynamicSectionContribution() {
        this.dynamicTestsView.setContributorId("org.eclipse.ui.tests.views.properties.tabbed.dynamic.section");
        this.select_RedStar();
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Star", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Advanced", (String)tabDescriptors[3].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((int)4, (int)tabDescriptors.length);
    }

    public void select_RedStar() {
        DynamicTestsTreeNode redStarNode = null;
        int i = 0;
        while (i < this.treeNodes.length) {
            if (DynamicTestsShape.STAR.equals(this.treeNodes[i].getDynamicTestsElement().getPropertyValue(DynamicTestsElement.ID_SHAPE))) {
                redStarNode = this.treeNodes[i];
                break;
            }
            ++i;
        }
        TabbedPropertySheetPageDynamicTest.assertNotNull(redStarNode);
        this.setSelection(new DynamicTestsTreeNode[]{redStarNode});
        ITabDescriptor[] tabDescriptors = this.dynamicTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Element", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageDynamicTest.assertEquals((String)"Color", (String)tabDescriptors[1].getLabel());
    }
}

