/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed;

import junit.framework.TestCase;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.tests.views.properties.tabbed.text.TextTestsLabelSection;
import org.eclipse.ui.tests.views.properties.tabbed.text.TextTestsView;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.TabContents;

public class TabbedPropertySheetPageTextTest
extends TestCase {
    private static final long TIME_OUT_TO_GET_ACTIVE_TABS = 30000L;
    private TextTestsView textTestsView;

    protected void setUp() throws Exception {
        super.setUp();
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TabbedPropertySheetPageTextTest.assertNotNull((Object)workbenchWindow);
        IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
        TabbedPropertySheetPageTextTest.assertNotNull((Object)workbenchPage);
        workbenchPage.closeAllPerspectives(false, false);
        PlatformUI.getWorkbench().showPerspective("org.eclipse.ui.tests.views.properties.tabbed.views.TestsPerspective", workbenchWindow);
        IViewPart view = workbenchPage.showView("org.eclipse.ui.tests.views.properties.tabbed.text.TextTestsView");
        TabbedPropertySheetPageTextTest.assertNotNull((Object)view);
        TabbedPropertySheetPageTextTest.assertTrue((boolean)(view instanceof TextTestsView));
        this.textTestsView = (TextTestsView)view;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void test_tabForSelectedTextDisplay() {
        IDocument document = this.textTestsView.getViewer().getDocument();
        document.set("This is a test");
        this.textTestsView.getViewer().setSelectedRange(0, 14);
        ITabDescriptor[] tabDescriptors = this.waitForActiveTabs();
        TabbedPropertySheetPageTextTest.assertEquals((String)"This", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((String)"is", (String)tabDescriptors[1].getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((String)"a", (String)tabDescriptors[2].getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((String)"test", (String)tabDescriptors[3].getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((int)4, (int)tabDescriptors.length);
    }

    public void test_tabSelectedTab() {
        IDocument document = this.textTestsView.getViewer().getDocument();
        document.set("The fifth tab is selected");
        this.textTestsView.getViewer().setSelectedRange(0, 26);
        ITabDescriptor[] tabDescriptors = this.waitForActiveTabs();
        TabbedPropertySheetPageTextTest.assertEquals((String)"The", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((String)"The", (String)this.textTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((String)"selected", (String)tabDescriptors[4].getLabel());
        this.textTestsView.getTabbedPropertySheetPage().setSelectedTab(tabDescriptors[4].getId());
        tabDescriptors = this.textTestsView.getTabbedPropertySheetPage().getActiveTabs();
        TabbedPropertySheetPageTextTest.assertEquals((String)"The", (String)tabDescriptors[0].getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((String)"selected", (String)tabDescriptors[4].getLabel());
        TabbedPropertySheetPageTextTest.assertEquals((String)"selected", (String)this.textTestsView.getTabbedPropertySheetPage().getSelectedTab().getLabel());
    }

    private ITabDescriptor[] waitForActiveTabs() {
        ITabDescriptor[] tabDescriptors;
        long threshold = System.currentTimeMillis() + 30000L;
        do {
            this.textTestsView.getSite().getShell().getDisplay().readAndDispatch();
        } while ((tabDescriptors = this.textTestsView.getTabbedPropertySheetPage().getActiveTabs()).length == 0 && System.currentTimeMillis() < threshold);
        TabbedPropertySheetPageTextTest.assertTrue((String)"No tab got activated", (tabDescriptors.length > 0 ? 1 : 0) != 0);
        return tabDescriptors;
    }

    public void test_listOfSections() {
        IDocument document = this.textTestsView.getViewer().getDocument();
        document.set("This is a test");
        this.textTestsView.getViewer().setSelectedRange(0, 14);
        this.waitForActiveTabs();
        TabContents tabContents = this.textTestsView.getTabbedPropertySheetPage().getCurrentTab();
        ISection[] sections = tabContents.getSections();
        TabbedPropertySheetPageTextTest.assertEquals((int)1, (int)sections.length);
        TabbedPropertySheetPageTextTest.assertEquals(TextTestsLabelSection.class, sections[0].getClass());
    }
}

