/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.views.properties.tabbed.dynamic.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.tests.views.properties.tabbed.Activator;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.model.DynamicTestsElement;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsTreeNode;
import org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsViewContentProvider;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DynamicTestsView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    public static final String DYNAMIC_TESTS_VIEW_ID = "org.eclipse.ui.tests.views.properties.tabbed.dynamic.views.DynamicTestsView";
    public static final String DYNAMIC_TESTS_VIEW_STATIC = "org.eclipse.ui.tests.views.properties.tabbed.static";
    public static final String DYNAMIC_TESTS_VIEW_DYNAMIC_TABS = "org.eclipse.ui.tests.views.properties.tabbed.dynamic.tab";
    public static final String DYNAMIC_TESTS_VIEW_DYNAMIC_SECTIONS = "org.eclipse.ui.tests.views.properties.tabbed.dynamic.section";
    private Action dynamicSectionsAction;
    private Action dynamicTabsAction;
    private Action staticAction;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private TreeViewer viewer;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new DynamicTestsViewContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new DynamicTestsViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.initToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            if (this.tabbedPropertySheetPage == null) {
                this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
            }
            return this.tabbedPropertySheetPage;
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        if (this.staticAction.isChecked()) {
            return DYNAMIC_TESTS_VIEW_STATIC;
        }
        if (this.dynamicSectionsAction.isChecked()) {
            return DYNAMIC_TESTS_VIEW_DYNAMIC_SECTIONS;
        }
        if (this.dynamicTabsAction.isChecked()) {
            return DYNAMIC_TESTS_VIEW_DYNAMIC_TABS;
        }
        return null;
    }

    public void setContributorId(String contributorId) {
        if (DYNAMIC_TESTS_VIEW_STATIC.equals(contributorId)) {
            this.staticAction.setChecked(true);
            this.dynamicSectionsAction.setChecked(false);
            this.dynamicTabsAction.setChecked(false);
        } else if (DYNAMIC_TESTS_VIEW_DYNAMIC_SECTIONS.equals(contributorId)) {
            this.staticAction.setChecked(false);
            this.dynamicSectionsAction.setChecked(true);
            this.dynamicTabsAction.setChecked(false);
        } else if (DYNAMIC_TESTS_VIEW_DYNAMIC_TABS.equals(contributorId)) {
            this.staticAction.setChecked(false);
            this.dynamicSectionsAction.setChecked(false);
            this.dynamicTabsAction.setChecked(true);
        }
    }

    public TabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.tabbedPropertySheetPage;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private void initToolBar() {
        ImageDescriptor imageDescriptor = Activator.getImageDescriptor("icons/sample.gif");
        if (imageDescriptor == null) {
            imageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
        }
        this.staticAction = new Action("Use static contributions from plugin.xml", 2){

            public void run() {
                if (this.isChecked()) {
                    DynamicTestsView.this.getViewSite().getActionBars().getStatusLineManager().setMessage("Use static contributions from plugin.xml");
                    DynamicTestsView.this.dynamicSectionsAction.setChecked(false);
                    DynamicTestsView.this.dynamicTabsAction.setChecked(false);
                    DynamicTestsView.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        };
        this.staticAction.setToolTipText("Use static contributions from plugin.xml");
        this.staticAction.setImageDescriptor(imageDescriptor);
        this.staticAction.setDisabledImageDescriptor(imageDescriptor);
        this.dynamicSectionsAction = new Action("Use dynamic section contributions from code", 2){

            public void run() {
                if (this.isChecked()) {
                    DynamicTestsView.this.getViewSite().getActionBars().getStatusLineManager().setMessage("Use dynamic section contributions from code");
                    DynamicTestsView.this.staticAction.setChecked(false);
                    DynamicTestsView.this.dynamicTabsAction.setChecked(false);
                    DynamicTestsView.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        };
        this.dynamicSectionsAction.setToolTipText("Use dynamic section contributions from code");
        this.dynamicSectionsAction.setImageDescriptor(imageDescriptor);
        this.dynamicSectionsAction.setDisabledImageDescriptor(imageDescriptor);
        this.dynamicTabsAction = new Action("Use dynamic tab (and section) contributions from code", 2){

            public void run() {
                if (this.isChecked()) {
                    DynamicTestsView.this.getViewSite().getActionBars().getStatusLineManager().setMessage("Use dynamic tab (and section) contributions from code");
                    DynamicTestsView.this.staticAction.setChecked(false);
                    DynamicTestsView.this.dynamicSectionsAction.setChecked(false);
                    DynamicTestsView.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        };
        this.dynamicTabsAction.setToolTipText("Use dynamic tab (and section) contributions from code");
        this.dynamicTabsAction.setImageDescriptor(imageDescriptor);
        this.dynamicTabsAction.setDisabledImageDescriptor(imageDescriptor);
        this.staticAction.setChecked(true);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.staticAction);
        toolBarManager.add((IAction)this.dynamicSectionsAction);
        toolBarManager.add((IAction)this.dynamicTabsAction);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage("Use static contributions from plugin.xml");
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class DynamicTestsViewLabelProvider
    extends LabelProvider {
        DynamicTestsViewLabelProvider() {
        }

        public Image getImage(Object obj) {
            DynamicTestsElement element = ((DynamicTestsTreeNode)((Object)obj)).getDynamicTestsElement();
            return element.getImage();
        }

        public String getText(Object obj) {
            DynamicTestsElement element = ((DynamicTestsTreeNode)((Object)obj)).getDynamicTestsElement();
            return element.getName();
        }
    }
}

